/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.profitwarehousing.service;

import java.util.List;

import com.jeeplus.modules.warehouse.code.util.CodeUtil;
import com.jeeplus.modules.warehouse.code.util.StaticNumSeq;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jeeplus.core.persistence.Page;
import com.jeeplus.core.service.CrudService;
import com.jeeplus.common.utils.StringUtils;
import com.jeeplus.modules.warehouse.profitwarehousing.entity.ProfitWarehousing;
import com.jeeplus.modules.warehouse.profitwarehousing.mapper.ProfitWarehousingMapper;
import com.jeeplus.modules.warehouse.profitwarehousing.entity.ProfitWarehousingInfo;
import com.jeeplus.modules.warehouse.profitwarehousing.mapper.ProfitWarehousingInfoMapper;

/**
 * 盘盈入库单Service
 * @author zhanglt
 * @version 2023-02-14
 */
@Service
@Transactional(readOnly = true)
public class ProfitWarehousingService extends CrudService<ProfitWarehousingMapper, ProfitWarehousing> {

	@Autowired
	private ProfitWarehousingInfoMapper profitWarehousingInfoMapper;
	
	public ProfitWarehousing get(String id) {
		ProfitWarehousing profitWarehousing = super.get(id);
		profitWarehousing.setProfitWarehousingInfoList(profitWarehousingInfoMapper.findList(new ProfitWarehousingInfo(profitWarehousing)));
		return profitWarehousing;
	}
	
	public List<ProfitWarehousing> findList(ProfitWarehousing profitWarehousing) {
		return super.findList(profitWarehousing);
	}
	
	public Page<ProfitWarehousing> findPage(Page<ProfitWarehousing> page, ProfitWarehousing profitWarehousing) {
		return super.findPage(page, profitWarehousing);
	}
	@Transactional(readOnly = false)
	public String createPYDH() {
		String pydh = CodeUtil.code("PYDH", StaticNumSeq.PYDH);
		return pydh;
	}
	@Transactional(readOnly = false)
	public void save(ProfitWarehousing profitWarehousing) {
		profitWarehousing.setNumber(createPYDH());
		super.save(profitWarehousing);
		for (ProfitWarehousingInfo profitWarehousingInfo : profitWarehousing.getProfitWarehousingInfoList()){
			profitWarehousingInfo.setProfitWarehousing(profitWarehousing);
			if (profitWarehousingInfo.getId() == null){
				continue;
			}
			if (ProfitWarehousingInfo.DEL_FLAG_NORMAL.equals(profitWarehousingInfo.getDelFlag())){
				if (StringUtils.isBlank(profitWarehousingInfo.getId())){
					profitWarehousingInfo.preInsert();
					profitWarehousingInfoMapper.insert(profitWarehousingInfo);
				}else{
					profitWarehousingInfo.preUpdate();
					profitWarehousingInfoMapper.update(profitWarehousingInfo);
				}
			}else{
				profitWarehousingInfoMapper.delete(profitWarehousingInfo);
			}
		}
	}
	
	@Transactional(readOnly = false)
	public void delete(ProfitWarehousing profitWarehousing) {
		super.delete(profitWarehousing);
		profitWarehousingInfoMapper.delete(new ProfitWarehousingInfo(profitWarehousing));
	}
	
}