/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.outbound.entity;


import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.common.utils.excel.annotation.ExcelField;
import com.jeeplus.modules.warehouse.ledger.entity.LedgerInfo;

/**
 * 出库单明细表Entity
 * @author zhanglt
 * @version 2023-02-14
 */
public class OutboundInfo extends DataEntity<OutboundInfo> {
	
	private static final long serialVersionUID = 1L;
	private Outbound outbound;		// 出库单主表id
	private LedgerInfo ledgerInfo;		// 台账明细表id
	
	public OutboundInfo() {
		super();
	}

	public OutboundInfo(String id){
		super(id);
	}

	public OutboundInfo(Outbound outbound, LedgerInfo ledgerInfo) {
		this.outbound = outbound;
		this.ledgerInfo = ledgerInfo;
	}

	public OutboundInfo(Outbound outbound) {
		this.outbound = outbound;
	}

	public OutboundInfo(String id, Outbound outbound, LedgerInfo ledgerInfo) {
		super(id);
		this.outbound = outbound;
		this.ledgerInfo = ledgerInfo;
	}

	@ExcelField(title="出库单主表id", align=2, sort=1)
	public Outbound getOutbound() {
		return outbound;
	}

	public void setOutbound(Outbound outbound) {
		this.outbound = outbound;
	}
	
	@ExcelField(title="台账明细表id", align=2, sort=2)
	public LedgerInfo getLedgerInfo() {
		return ledgerInfo;
	}

	public void setLedgerInfo(LedgerInfo ledgerInfo) {
		this.ledgerInfo = ledgerInfo;
	}
	
}