package com.jeeplus.modules.warehouse.ikanalyzer;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import org.wltea.analyzer.cfg.DefaultConfig;
import org.wltea.analyzer.core.Lexeme;
import org.wltea.analyzer.cfg.Configuration;

public class IKSegmenter {
    private static Configuration m_wordCut_cfg;


    public String parse(String content, boolean useSmart) throws Exception{
        StringReader sr = new StringReader(content);
        // 参数2为是否使用智能分词
        // true：使用智能分词
        // false：使用最细粒度分词
        org.wltea.analyzer.core.IKSegmenter ikSegmenter = new org.wltea.analyzer.core.IKSegmenter(sr, useSmart);
        Lexeme word = null;
        String w = null;
        StringBuffer sb = new StringBuffer();
        while((word = ikSegmenter.next()) != null){
            w = word.getLexemeText();
//            int nTtype = word.getLexemeType();
//            if (nTtype == 64) continue;
            if(sb.length() > 0){
                sb.append("|");
            }
            sb.append(w);
        }
        return sb.toString();
    }

    /**
     * 分词方法
     * @param text 需要拆分的字符串
     * @param b ture为智能拆分，false为最细粒度拆分
     * @return
     */
    public static List<String> splitStr(String text, boolean b) {
        String strs = text;
        m_wordCut_cfg = DefaultConfig.getInstance();
        try {
            IKSegmenter ikSegmenterTest = new IKSegmenter();
            strs = ikSegmenterTest.parse(text,b);
        } catch (Exception e) {
            e.printStackTrace();
        }
        List<String> list = new ArrayList<>();
        String [] strArr = strs.split("|");
        for (String str : strArr) {
            list.add(str);
        }
        return list;
    }
    public static void main(String[] args) {
        String text = "185的绿军鞋15双";
        System.out.println("使用智能分词结果："+splitStr(text, true));
        System.out.println("最细粒度分词结果："+splitStr(text, false));
    }
}
