/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.wzcode.web;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;

import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.multipart.MultipartFile;

import com.google.common.collect.Lists;
import com.jeeplus.common.utils.DateUtils;
import com.jeeplus.common.config.Global;
import com.jeeplus.common.json.AjaxJson;
import com.jeeplus.core.persistence.Page;
import com.jeeplus.core.web.BaseController;
import com.jeeplus.common.utils.StringUtils;
import com.jeeplus.common.utils.excel.ExportExcel;
import com.jeeplus.common.utils.excel.ImportExcel;
import com.jeeplus.modules.warehouse.wzcode.entity.Wzcode;
import com.jeeplus.modules.warehouse.wzcode.service.WzcodeService;

/**
 * 物资编码模块Controller
 * @author 胡懿
 * @version 2023-02-24
 */
@Controller
@RequestMapping(value = "${adminPath}/warehouse/wzcode/wzcode")
public class WzcodeController extends BaseController {

	@Autowired
	private WzcodeService wzcodeService;
	
	@ModelAttribute
	public Wzcode get(@RequestParam(required=false) String id) {
		Wzcode entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = wzcodeService.get(id);
		}
		if (entity == null){
			entity = new Wzcode();
		}
		return entity;
	}
	
	/**
	 * 物资编码模块列表页面
	 */
	@RequiresPermissions("warehouse:wzcode:wzcode:list")
	@RequestMapping(value = {"list", ""})
	public String list(Wzcode wzcode, Model model) {
		model.addAttribute("wzcode", wzcode);
		return "modules/warehouse/wzcode/wzcodeList";
	}
	
		/**
	 * 物资编码模块列表数据
	 */
	@ResponseBody
	@RequiresPermissions("warehouse:wzcode:wzcode:list")
	@RequestMapping(value = "data")
	public Map<String, Object> data(Wzcode wzcode, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<Wzcode> page = wzcodeService.findPage(new Page<Wzcode>(request, response), wzcode); 
		return getBootstrapData(page);
	}

	/**
	 * 查看，增加，编辑物资编码模块表单页面
	 */
	@RequiresPermissions(value={"warehouse:wzcode:wzcode:view","warehouse:wzcode:wzcode:add","warehouse:wzcode:wzcode:edit"},logical=Logical.OR)
	@RequestMapping(value = "form/{mode}")
	public String form(@PathVariable String mode, Wzcode wzcode, Model model) {
		model.addAttribute("wzcode", wzcode);
		model.addAttribute("mode", mode);
		return "modules/warehouse/wzcode/wzcodeForm";
	}

	/**
	 * 保存物资编码模块
	 */
	@ResponseBody
	@RequiresPermissions(value={"warehouse:wzcode:wzcode:add","warehouse:wzcode:wzcode:edit"},logical=Logical.OR)
	@RequestMapping(value = "save")
	public AjaxJson save(Wzcode wzcode, Model model) throws Exception{
		AjaxJson j = new AjaxJson();
		/**
		 * 后台hibernate-validation插件校验
		 */
		String errMsg = beanValidator(wzcode);
		if (StringUtils.isNotBlank(errMsg)){
			j.setSuccess(false);
			j.setMsg(errMsg);
			return j;
		}
		//新增或编辑表单保存
		wzcodeService.save(wzcode);//保存
		j.setSuccess(true);
		j.setMsg("保存物资编码模块成功");
		return j;
	}
	
	/**
	 * 删除物资编码模块
	 */
	@ResponseBody
	@RequiresPermissions("warehouse:wzcode:wzcode:del")
	@RequestMapping(value = "delete")
	public AjaxJson delete(Wzcode wzcode) {
		AjaxJson j = new AjaxJson();
		wzcodeService.delete(wzcode);
		j.setMsg("删除物资编码模块成功");
		return j;
	}
	
	/**
	 * 批量删除物资编码模块
	 */
	@ResponseBody
	@RequiresPermissions("warehouse:wzcode:wzcode:del")
	@RequestMapping(value = "deleteAll")
	public AjaxJson deleteAll(String ids) {
		AjaxJson j = new AjaxJson();
		String idArray[] =ids.split(",");
		for(String id : idArray){
			wzcodeService.delete(wzcodeService.get(id));
		}
		j.setMsg("删除物资编码模块成功");
		return j;
	}
	
	/**
	 * 导出excel文件
	 */
	@ResponseBody
	@RequiresPermissions("warehouse:wzcode:wzcode:export")
    @RequestMapping(value = "export")
    public AjaxJson exportFile(Wzcode wzcode, HttpServletRequest request, HttpServletResponse response) {
		AjaxJson j = new AjaxJson();
		try {
            String fileName = "物资编码模块"+DateUtils.getDate("yyyyMMddHHmmss")+".xlsx";
            Page<Wzcode> page = wzcodeService.findPage(new Page<Wzcode>(request, response, -1), wzcode);
    		new ExportExcel("物资编码模块", Wzcode.class).setDataList(page.getList()).write(response, fileName).dispose();
    		j.setSuccess(true);
    		j.setMsg("导出成功！");
    		return j;
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg("导出物资编码模块记录失败！失败信息："+e.getMessage());
		}
			return j;
    }

	/**
	 * 导入Excel数据

	 */
	@ResponseBody
	@RequiresPermissions("warehouse:wzcode:wzcode:import")
    @RequestMapping(value = "import")
   	public AjaxJson importFile(@RequestParam("file")MultipartFile file, HttpServletResponse response, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		try {
			int successNum = 0;
			int failureNum = 0;
			StringBuilder failureMsg = new StringBuilder();
			ImportExcel ei = new ImportExcel(file, 1, 0);
			List<Wzcode> list = ei.getDataList(Wzcode.class);
			for (Wzcode wzcode : list){
				try{
					wzcodeService.save(wzcode);
					successNum++;
				}catch(ConstraintViolationException ex){
					failureNum++;
				}catch (Exception ex) {
					failureNum++;
				}
			}
			if (failureNum>0){
				failureMsg.insert(0, "，失败 "+failureNum+" 条物资编码模块记录。");
			}
			j.setMsg( "已成功导入 "+successNum+" 条物资编码模块记录"+failureMsg);
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg("导入物资编码模块失败！失败信息："+e.getMessage());
		}
		return j;
    }
	
	/**
	 * 下载导入物资编码模块数据模板
	 */
	@ResponseBody
	@RequiresPermissions("warehouse:wzcode:wzcode:import")
    @RequestMapping(value = "import/template")
     public AjaxJson importFileTemplate(HttpServletResponse response) {
		AjaxJson j = new AjaxJson();
		try {
            String fileName = "物资编码模块数据导入模板.xlsx";
    		List<Wzcode> list = Lists.newArrayList(); 
    		new ExportExcel("物资编码模块数据", Wzcode.class, 1).setDataList(list).write(response, fileName).dispose();
    		return null;
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg( "导入模板下载失败！失败信息："+e.getMessage());
		}
		return j;
    }

}