/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.storage.entity;

import com.jeeplus.modules.sys.entity.User;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import com.google.common.collect.Lists;

import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.common.utils.excel.annotation.ExcelField;
import com.jeeplus.modules.warehouse.qrcode.entity.QrCode;
import com.jeeplus.modules.warehouse.storage.dto.CountStorageInfo;

/**
 * 入库信息Entity
 * @author huyi
 * @version 2023-02-13
 */
public class Storage extends DataEntity<Storage> {
	
	private static final long serialVersionUID = 1L;
	private String code;		// 入库单
	private User operator;		// 操作人
	private Date time;		// 时间
	private String batchNum;		// 批次号
	private Date beginTime;		// 开始 时间
	private Date endTime;		// 结束 时间
	private BigDecimal sum; // 总价
	private List<StorageInfo> storageInfoList = Lists.newArrayList();		// 子表列表

	private List<CountStorageInfo> countStorageInfoList; // 前端使用的入库明细统计信息


	public Storage() {
		super();
	}

	public Storage(String id){
		super(id);
	}

	@ExcelField(title="入库单", align=2, sort=1)
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	@ExcelField(title="操作人", fieldType=User.class, value="operator.name", align=2, sort=2)
	public User getOperator() {
		return operator;
	}

	public void setOperator(User operator) {
		this.operator = operator;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@ExcelField(title="时间", align=2, sort=3)
	public Date getTime() {
		return time;
	}

	public void setTime(Date time) {
		this.time = time;
	}
	
	@ExcelField(title="批次号", align=2, sort=4)
	public String getBatchNum() {
		return batchNum;
	}

	public void setBatchNum(String batchNum) {
		this.batchNum = batchNum;
	}
	
	public Date getBeginTime() {
		return beginTime;
	}

	public void setBeginTime(Date beginTime) {
		this.beginTime = beginTime;
	}
	
	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}
		
	public List<StorageInfo> getStorageInfoList() {
		return storageInfoList;
	}

	public void setStorageInfoList(List<StorageInfo> storageInfoList) {
		this.storageInfoList = storageInfoList;
	}

	public BigDecimal getSum() {
		return sum;
	}

	public void setSum(BigDecimal sum) {
		this.sum = sum;
	}

	public List<CountStorageInfo> getCountStorageInfoList() {
		return countStorageInfoList;
	}

	public void setCountStorageInfoList(List<CountStorageInfo> countStorageInfoList) {
		this.countStorageInfoList = countStorageInfoList;
	}
}