package com.jeeplus.modules.warehouse.shelves.utils;

import com.jeeplus.common.utils.CacheUtils;
import com.jeeplus.common.utils.SpringContextHolder;
import com.jeeplus.common.utils.StringUtils;
import com.jeeplus.modules.warehouse.shelves.entity.Shelves;
import com.jeeplus.modules.warehouse.shelves.mapper.ShelvesMapper;
import com.jeeplus.modules.warehouse.warehouse.entity.Warehouse;
import com.jeeplus.modules.warehouse.warehouse.mapper.WarehouseMapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ShelvesUtil {

    private static ShelvesMapper shelvesMapper = SpringContextHolder.getBean(ShelvesMapper.class);
    private static WarehouseMapper warehouseMapper = SpringContextHolder.getBean(WarehouseMapper.class);

    public static final String SHELCES_CACHE = "shelvesCache";
    public static final String SHELCES_ID = "shelvesId_";
    public static final String WAREHOUSE_CACHE = "warehouseCache";
    public static final String WAREHOUSE_ID = "warehouseId_";

    public static String mergeShevlesName(Set<Shelves> set) {

        return "";
    }

    /**
     * 整合仓库名称，返回（a,b,c）
     * @param warehousesNames
     * @return
     */
    public static String mergerWarehouseName(Set<String> warehousesNames) {
        List<String> wList = new ArrayList<>();
        for (String wName : warehousesNames) {
            wList.add(wName);
        }

        StringBuffer sb = new StringBuffer();
        for (int i =0; i < wList.size(); i ++) {
            if (0 != wList.size()) {
                sb.append(wList.get(i));
                if (i != wList.size() - 1) {
                    sb.append(",");
                }
            } else {
                sb.append(wList.get(i));
            }
        }
        return sb.toString();
    }

    /**
     * 从缓存中获取货架信息
     * @param ids
     * @return
     */
    public static List<Shelves> getShelvesListByIds(String ids) {
        List<Shelves> resultList = new ArrayList<>();
        if (StringUtils.isNotBlank(ids)) {
            String [] idsArr = ids.split(",");
            for (String id : idsArr) {
                if (StringUtils.isNotBlank(id)) {
                    Shelves shelves = (Shelves) CacheUtils.get(SHELCES_CACHE, SHELCES_ID + id);
                    if (null == shelves || StringUtils.isBlank(shelves.getId())) {
                        Shelves tem = new Shelves();
                        tem.setDelFlag("0");
                        List<Shelves> list =  shelvesMapper.findList(tem);
                        for (Shelves s : list) {
                            CacheUtils.put(SHELCES_CACHE, SHELCES_ID + s.getId(), s);
                        }
                        shelves = (Shelves) CacheUtils.get(SHELCES_CACHE, SHELCES_ID + id);
                        resultList.add(shelves);
                    } else {
                        resultList.add(shelves);
                    }
                }
            }
        }
        return resultList;
    }

    /**
     * 从缓冲中获取仓库id
     * @param ids
     * @return
     */
    public static List<Warehouse> getWarehouseListByIds(String ids) {
        List<Warehouse> resultList = new ArrayList<>();
        if (StringUtils.isNotBlank(ids)) {
            String [] idsArr = ids.split(",");
            for (String id : idsArr) {
                if (StringUtils.isNotBlank(id)) {
                    Warehouse warehouse = (Warehouse) CacheUtils.get(WAREHOUSE_CACHE, WAREHOUSE_ID + id);
                    if (null == warehouse || StringUtils.isBlank(warehouse.getId())) {
                        Warehouse tem = new Warehouse();
                        tem.setDelFlag("0");
                        List<Warehouse> list =  warehouseMapper.findList(tem);
                        for (Warehouse w : list) {
                            CacheUtils.put(WAREHOUSE_CACHE, WAREHOUSE_ID + w.getId(), w);
                        }
                        warehouse = (Warehouse) CacheUtils.get(WAREHOUSE_CACHE, WAREHOUSE_ID + id);
                        resultList.add(warehouse);
                    } else {
                        resultList.add(warehouse);
                    }
                }
            }
        }
        return resultList;
    }
}
