package com.jeeplus.modules.warehouse.qrcode.util;

import com.alibaba.fastjson.JSON;
import com.jeeplus.common.utils.io.FileUtil;
import com.jeeplus.modules.warehouse.goods.entity.GoodsInfo;
import com.jeeplus.modules.warehouse.profitwarehousing.entity.ProfitWarehousingInfo;
import com.jeeplus.modules.warehouse.qrcode.entity.QrCode;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class BuildQcUtil {
    /**
     *
     * @param qrCode 二维码对象，里面必须包含完整的goodsInfos对象
     * @param qrImgPath 二维码路径
     * @param imgPath 最后生成的图片路径
     * @throws IOException
     */
    public static void buildQr(QrCode qrCode, String qrImgPath, String imgPath) throws IOException {
        GoodsInfo goodsInfo = qrCode.getGoodsInfo();
        Map<String, String> map = new HashMap<>();
        map.put("code", qrCode.getId());
        map.put("infoId", goodsInfo.getId());
        TwoDimensionCode.encoderQRCode(JSON.toJSONString(map), qrImgPath, "png", 6);
        File file = new File(qrImgPath);
        File file2 = new File(imgPath);
        if (file2.exists()) {
            file2.delete();
        }
        try {
            BufferedImage image = DrawQrcodeUtil.createAssetImageNew(file, qrCode);
            DrawQrcodeUtil drawQrcodeUtil = new DrawQrcodeUtil();
            drawQrcodeUtil.writeImage(image, imgPath);
        } catch (IOException e) {
            e.printStackTrace();
        }
        FileUtil.deleteFile(file);
    }

    public static void buildQrOne(QrCode qrCode, String qrImgPath, String imgPath) throws IOException {
        ProfitWarehousingInfo profitWarehousingInfo = qrCode.getProfitWarehousingInfo();
        Map<String, String> map = new HashMap<>();
        map.put("code", qrCode.getId());
        map.put("infoId", profitWarehousingInfo.getId());
        TwoDimensionCode.encoderQRCode(JSON.toJSONString(map), qrImgPath, "png", 6);
        File file = new File(qrImgPath);
        try {
            BufferedImage image = DrawQrcodeUtil.createAssetImageNew2(file, qrCode);
            DrawQrcodeUtil drawQrcodeUtil = new DrawQrcodeUtil();
            drawQrcodeUtil.writeImage(image, imgPath);
        } catch (IOException e) {
            e.printStackTrace();
        }
        FileUtil.deleteFile(file);
    }
}
