/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.profitwarehousing.entity;

import com.jeeplus.modules.warehouse.materialtype.entity.MaterialType;
import com.jeeplus.modules.warehouse.outbound.entity.Outbound;
import com.jeeplus.modules.warehouse.qrcode.entity.QrCode;
import com.jeeplus.modules.warehouse.shelves.entity.Shelves;

import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.common.utils.excel.annotation.ExcelField;
import com.jeeplus.modules.warehouse.storage.entity.Storage;
import com.jeeplus.modules.warehouse.warehouse.entity.Warehouse;

import java.math.BigDecimal;
import java.util.List;

/**
 * 盘盈入库单明细表Entity
 * @author zhanglt
 * @version 2023-02-14
 */
public class ProfitWarehousingInfo extends DataEntity<ProfitWarehousingInfo> {
	
	private static final long serialVersionUID = 1L;
	private ProfitWarehousing profitWarehousing;		// 盘盈入库主表ID
	private String name;		// 名称
	private MaterialType type;		// 类型
	private String marking;		// 型号
	// private Shelves shelves;		// 货架ID
	private Warehouse warehouse; // 仓库外键
	private BigDecimal amount; // 单价
	private QrCode qrCode; // 前端保存入库单时使用的临时二维码对象
	private int num; // 数量
	private String shelvesIds; // 货架ids
	private String warehouseIds; // 仓库ids

	private List<Shelves> shelvesList;
	private List<Warehouse> warehouseList;

	public ProfitWarehousingInfo(String id, ProfitWarehousing profitWarehousing) {
		super(id);
		this.profitWarehousing = profitWarehousing;
	}
	public ProfitWarehousingInfo() {
		super();
	}

	public ProfitWarehousingInfo(String id){
		super(id);
	}

	public ProfitWarehousingInfo(ProfitWarehousing profitWarehousing) {
		this.profitWarehousing = profitWarehousing;
	}

	@ExcelField(title="盘盈入库主表ID", align=2, sort=1)
	public ProfitWarehousing getProfitWarehousing() {
		return profitWarehousing;
	}

	public void setProfitWarehousing(ProfitWarehousing profitWarehousing) {
		this.profitWarehousing = profitWarehousing;
	}
	
	@ExcelField(title="名称", align=2, sort=2)
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@ExcelField(title="类型", align=2, sort=3)
	public MaterialType getType() {
		return type;
	}

	public void setType(MaterialType type) {
		this.type = type;
	}
	
	@ExcelField(title="型号", align=2, sort=4)
	public String getMarking() {
		return marking;
	}

	public void setMarking(String marking) {
		this.marking = marking;
	}

	public Warehouse getWarehouse() {
		return warehouse;
	}

	public void setWarehouse(Warehouse warehouse) {
		this.warehouse = warehouse;
	}

	public BigDecimal getAmount() {
		return amount;
	}

	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}

	public QrCode getQrCode() {
		return qrCode;
	}

	public void setQrCode(QrCode qrCode) {
		this.qrCode = qrCode;
	}

	public int getNum() {
		return num;
	}

	public void setNum(int num) {
		this.num = num;
	}

	public String getShelvesIds() {
		return shelvesIds;
	}

	public void setShelvesIds(String shelvesIds) {
		this.shelvesIds = shelvesIds;
	}

	public String getWarehouseIds() {
		return warehouseIds;
	}

	public void setWarehouseIds(String warehouseIds) {
		this.warehouseIds = warehouseIds;
	}

	public List<Shelves> getShelvesList() {
		return shelvesList;
	}

	public void setShelvesList(List<Shelves> shelvesList) {
		this.shelvesList = shelvesList;
	}

	public List<Warehouse> getWarehouseList() {
		return warehouseList;
	}

	public void setWarehouseList(List<Warehouse> warehouseList) {
		this.warehouseList = warehouseList;
	}
}