/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.materialrequisition.entity;


import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.common.utils.excel.annotation.ExcelField;
import com.jeeplus.modules.sys.entity.User;
import com.jeeplus.modules.warehouse.ledger.entity.LedgerInfo;

/**
 * 领用明细表Entity
 * @author zhanglt
 * @version 2023-02-13
 */
public class MaterialRequisitionInfo extends DataEntity<MaterialRequisitionInfo> {
	
	private static final long serialVersionUID = 1L;
	private MaterialRequisition materialRequisition;		// 物资领用主表ID
	private String receiver;		// 领用人
	private LedgerInfo ledgerInfo;		// 物资台账明细ID
	
	public MaterialRequisitionInfo() {
		super();
	}

	public MaterialRequisitionInfo(MaterialRequisition materialRequisition) {
		this.materialRequisition = materialRequisition;
	}

	public MaterialRequisitionInfo(String id){
		super(id);
	}

	@ExcelField(title="物资领用主表ID", align=2, sort=1)
	public MaterialRequisition getMaterialRequisition() {
		return materialRequisition;
	}

	public void setMaterialRequisition(MaterialRequisition materialRequisition) {
		this.materialRequisition = materialRequisition;
	}
	
	@ExcelField(title="物资台账明细ID", align=2, sort=2)
	public LedgerInfo getLedgerInfo() {
		return ledgerInfo;
	}
	@ExcelField(title="领用人", align=2, sort=3)
	public String getReceiver() {
		return receiver;
	}

	public void setReceiver(String receiver) {
		this.receiver = receiver;
	}

	public void setLedgerInfo(LedgerInfo ledgerInfo) {
		this.ledgerInfo = ledgerInfo;
	}
	
}