/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.materialrequisition.entity;

import com.jeeplus.modules.sys.entity.Office;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import com.google.common.collect.Lists;

import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.common.utils.excel.annotation.ExcelField;
import com.jeeplus.modules.sys.entity.User;

/**
 * 物资领用Entity
 * @author zhanglt
 * @version 2023-02-13
 */
public class MaterialRequisition extends DataEntity<MaterialRequisition> {
	
	private static final long serialVersionUID = 1L;
	private String number;		// 领用单号
	private String status;		// 出库状态 1未出库 2已出库
	private User operator;		// 操作人
//	private String receiver;		// 领用人
	private Office office;		// 领用机构
	private Date time;		// 领用时间
	private Date beginOutboundTime;		// 开始 领用时间
	private Date endOutboundTime;		// 结束 领用时间
	private List<MaterialRequisitionInfo> materialRequisitionInfoList = Lists.newArrayList();		// 子表列表
	
	public MaterialRequisition() {
		super();
	}

	public MaterialRequisition(String id){
		super(id);
	}

	@ExcelField(title="领用单号", align=2, sort=1)
	public String getNumber() {
		return number;
	}

	public void setNumber(String number) {
		this.number = number;
	}
	
	@ExcelField(title="操作人", align=2, sort=2)
	public User getOperator() {
		return operator;
	}

	public void setOperator(User operator) {
		this.operator = operator;
	}

	
	@ExcelField(title="领用机构", fieldType=Office.class, value="", align=2, sort=4)
	public Office getOffice() {
		return office;
	}

	public void setOffice(Office office) {
		this.office = office;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@ExcelField(title="领用时间", align=2, sort=5)
	public Date getTime() {
		return time;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public void setTime(Date time) {
		this.time = time;
	}

	public Date getBeginOutboundTime() {
		return beginOutboundTime;
	}

	public void setBeginOutboundTime(Date beginOutboundTime) {
		this.beginOutboundTime = beginOutboundTime;
	}

	public Date getEndOutboundTime() {
		return endOutboundTime;
	}

	public void setEndOutboundTime(Date endOutboundTime) {
		this.endOutboundTime = endOutboundTime;
	}

	public List<MaterialRequisitionInfo> getMaterialRequisitionInfoList() {
		return materialRequisitionInfoList;
	}

	public void setMaterialRequisitionInfoList(List<MaterialRequisitionInfo> materialRequisitionInfoList) {
		this.materialRequisitionInfoList = materialRequisitionInfoList;
	}
}