/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.ledger.entity;

import com.jeeplus.modules.warehouse.ledger.dto.CountLedgerInfo;
import com.jeeplus.modules.warehouse.materialtype.entity.MaterialType;

import java.math.BigDecimal;
import java.util.List;
import com.google.common.collect.Lists;

import com.jeeplus.core.persistence.DataEntity;
import com.jeeplus.common.utils.excel.annotation.ExcelField;

import javax.validation.constraints.NotNull;

/**
 * 台账信息Entity
 * @author huyi
 * @version 2023-02-13
 */
public class Ledger extends DataEntity<Ledger> {
	
	private static final long serialVersionUID = 1L;
	private String name;		// 物资名称
	private MaterialType type;		// 类型
	private String shelvesIds;		// 货架id集合
	private Integer num;		// 数量
	private BigDecimal sum; // 总价格
	private List<LedgerInfo> ledgerInfoList = Lists.newArrayList();		// 子表列表

	private List<CountLedgerInfo> countLedgerInfoList; // 前端展示使用的统计明细信息
	
	public Ledger() {
		super();
	}

	public Ledger(String id){
		super(id);
	}

	public Ledger(MaterialType type) {
		this.type = type;
	}

	@NotNull(message="物资名称不能为空")
	@ExcelField(title="物资名称", align=2, sort=1)
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@NotNull(message="类型不能为空")
	@ExcelField(title="类型", fieldType=MaterialType.class, value="type.name", align=2, sort=2)
	public MaterialType getType() {
		return type;
	}

	public void setType(MaterialType type) {
		this.type = type;
	}

	@ExcelField(title="货架id集合", align=2, sort=4)
	public String getShelvesIds() {
		return shelvesIds;
	}

	public void setShelvesIds(String shelvesIds) {
		this.shelvesIds = shelvesIds;
	}

	@NotNull(message="数量不能为空")
	@ExcelField(title="数量", align=2, sort=5)
	public Integer getNum() {
		return num;
	}

	public void setNum(Integer num) {
		this.num = num;
	}

	@NotNull(message="单价不能为空")
	@ExcelField(title="单价", align=2, sort=6)
	public BigDecimal getSum() {
		return sum;
	}

	public void setSum(BigDecimal sum) {
		this.sum = sum;
	}

	public List<LedgerInfo> getLedgerInfoList() {
		return ledgerInfoList;
	}

	public void setLedgerInfoList(List<LedgerInfo> ledgerInfoList) {
		this.ledgerInfoList = ledgerInfoList;
	}

	public List<CountLedgerInfo> getCountLedgerInfoList() {
		return countLedgerInfoList;
	}

	public void setCountLedgerInfoList(List<CountLedgerInfo> countLedgerInfoList) {
		this.countLedgerInfoList = countLedgerInfoList;
	}
}