package com.jeeplus.modules.warehouse.ledger.dto;

import com.jeeplus.modules.warehouse.goods.entity.GoodsInfo;
import com.jeeplus.modules.warehouse.ledger.entity.Ledger;
import com.jeeplus.modules.warehouse.materialtype.entity.MaterialType;
import com.jeeplus.modules.warehouse.qrcode.entity.QrCode;
import com.jeeplus.modules.warehouse.shelves.entity.Shelves;

import java.math.BigDecimal;

public class CountLedgerInfo {
    private static final long serialVersionUID = 1L;
    private String name;		// 物资名称
    private MaterialType type;		// 类型
    private String model;		// 型号
    private String batchNum;		// 批次号
    private Ledger ledger;		// 主表外键 父类
    private GoodsInfo goodsInfo;		// 货品明细
    private QrCode qr;		// 二维码id
    private Shelves shelves;		// 货架id
    private String code;		// 物资编码
    private BigDecimal sum; // 单价
    private int num; // 数量

    private String shelvesNames; // 多个货架信息，前端展示使用
    private String warehouseNames; // 多个仓库信息，前端展示使用

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MaterialType getType() {
        return type;
    }

    public void setType(MaterialType type) {
        this.type = type;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getBatchNum() {
        return batchNum;
    }

    public void setBatchNum(String batchNum) {
        this.batchNum = batchNum;
    }

    public Ledger getLedger() {
        return ledger;
    }

    public void setLedger(Ledger ledger) {
        this.ledger = ledger;
    }

    public GoodsInfo getGoodsInfo() {
        return goodsInfo;
    }

    public void setGoodsInfo(GoodsInfo goodsInfo) {
        this.goodsInfo = goodsInfo;
    }

    public QrCode getQr() {
        return qr;
    }

    public void setQr(QrCode qr) {
        this.qr = qr;
    }

    public Shelves getShelves() {
        return shelves;
    }

    public void setShelves(Shelves shelves) {
        this.shelves = shelves;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BigDecimal getSum() {
        return sum;
    }

    public void setSum(BigDecimal sum) {
        this.sum = sum;
    }

    public int getNum() {
        return num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public String getShelvesNames() {
        return shelvesNames;
    }

    public void setShelvesNames(String shelvesNames) {
        this.shelvesNames = shelvesNames;
    }

    public String getWarehouseNames() {
        return warehouseNames;
    }

    public void setWarehouseNames(String warehouseNames) {
        this.warehouseNames = warehouseNames;
    }
}
