/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.code.entity;


import com.jeeplus.common.utils.excel.annotation.ExcelField;
import com.jeeplus.core.persistence.DataEntity;

/**
 * 编码序列Entity
 * @author admin
 * @version 2021-09-06
 */
public class NumSeq extends DataEntity<NumSeq> {
	
	private static final long serialVersionUID = 1L;
	private String name;		//模块名
	private String module;		// 模块编码
	private String month;		// 模块用月份
	private Integer seq;		// 序列号
	
	public NumSeq() {
		super();
	}

	public NumSeq(String id){
		super(id);
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@ExcelField(title="模块编码", align=2, sort=1)
	public String getModule() {
		return module;
	}

	public void setModule(String module) {
		this.module = module;
	}
	
	@ExcelField(title="模块用月份", align=2, sort=2)
	public String getMonth() {
		return month;
	}

	public void setMonth(String month) {
		this.month = month;
	}
	
	@ExcelField(title="序列号", align=2, sort=3)
	public Integer getSeq() {
		return seq;
	}

	public void setSeq(Integer seq) {
		this.seq = seq;
	}
	
}