/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.qrcode.service;

import java.util.List;

import com.jeeplus.common.utils.StringUtils;
import com.jeeplus.modules.warehouse.goods.entity.GoodsInfo;
import com.jeeplus.modules.warehouse.ikanalyzer.IKSegmenter;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jeeplus.core.persistence.Page;
import com.jeeplus.core.service.CrudService;
import com.jeeplus.modules.warehouse.qrcode.entity.QrCode;
import com.jeeplus.modules.warehouse.qrcode.mapper.QrCodeMapper;

/**
 * 二维码Service
 * @author 胡懿
 * @version 2023-02-13
 */
@Service
@Transactional(readOnly = true)
public class QrCodeService extends CrudService<QrCodeMapper, QrCode> {

	public QrCode get(String id) {
		return super.get(id);
	}
	
	public List<QrCode> findList(QrCode qrCode) {
		return super.findList(qrCode);
	}
	
	public Page<QrCode> findPage(Page<QrCode> page, QrCode qrCode) {
		GoodsInfo goodsInfo = qrCode.getGoodsInfo();
		if (null != goodsInfo) {
			if (StringUtils.isNotBlank(goodsInfo.getModel())) {
				goodsInfo.setModelList(IKSegmenter.splitStr(goodsInfo.getModel(), false));
			}
		}
		return super.findPage(page, qrCode);
	}
	
	@Transactional(readOnly = false)
	public void save(QrCode qrCode) {
		super.save(qrCode);
	}
	
	@Transactional(readOnly = false)
	public void delete(QrCode qrCode) {
		super.delete(qrCode);
	}
	
}