/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.outbound.service;

import java.util.List;
import java.util.Objects;

import com.jeeplus.modules.warehouse.code.util.CodeUtil;
import com.jeeplus.modules.warehouse.code.util.StaticNumSeq;
import com.jeeplus.modules.warehouse.ledger.entity.Ledger;
import com.jeeplus.modules.warehouse.ledger.entity.LedgerInfo;
import com.jeeplus.modules.warehouse.ledger.mapper.LedgerInfoMapper;
import com.jeeplus.modules.warehouse.ledger.mapper.LedgerMapper;
import com.jeeplus.modules.warehouse.ledger.service.LedgerService;
import com.jeeplus.modules.warehouse.materialrequisition.entity.MaterialRequisitionInfo;
import com.jeeplus.modules.warehouse.qrcode.entity.QrCode;
import com.jeeplus.modules.warehouse.qrcode.service.QrCodeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jeeplus.core.persistence.Page;
import com.jeeplus.core.service.CrudService;
import com.jeeplus.common.utils.StringUtils;
import com.jeeplus.modules.warehouse.outbound.entity.Outbound;
import com.jeeplus.modules.warehouse.outbound.mapper.OutboundMapper;
import com.jeeplus.modules.warehouse.outbound.entity.OutboundInfo;
import com.jeeplus.modules.warehouse.outbound.mapper.OutboundInfoMapper;

/**
 * 出库信息Service
 * @author zhanglt
 * @version 2023-02-14
 */
@Service
@Transactional(readOnly = true)
public class OutboundService extends CrudService<OutboundMapper, Outbound> {

	@Autowired
	private OutboundInfoMapper outboundInfoMapper;
	@Autowired
	private LedgerInfoMapper ledgerInfoMapper;
	@Autowired
	private LedgerService ledgerService;
	@Autowired
	private QrCodeService qrCodeService;

	
	public Outbound get(String id) {
		Outbound outbound = super.get(id);
		outbound.setOutboundInfoList(outboundInfoMapper.findList(new OutboundInfo(outbound)));
		return outbound;
	}
	
	public List<Outbound> findList(Outbound outbound) {
		return super.findList(outbound);
	}
	
	public Page<Outbound> findPage(Page<Outbound> page, Outbound outbound) {
		return super.findPage(page, outbound);
	}

	//出库并下账
	@Transactional(readOnly = false)
	public void save(Outbound outbound) {
		if(outbound.getNumber() == null || Objects.equals(outbound.getNumber(), "")){
			outbound.setNumber(this.createCKDH());
		}
		super.save(outbound);
		for (OutboundInfo outboundInfo : outbound.getOutboundInfoList()){
			if (outboundInfo.getId() == null){
				continue;
			}
			if (OutboundInfo.DEL_FLAG_NORMAL.equals(outboundInfo.getDelFlag())){
				if (StringUtils.isBlank(outboundInfo.getId())){
					outboundInfo.setOutbound(outbound);
					outboundInfo.preInsert();
					outboundInfoMapper.insert(outboundInfo);
				}else{
					outboundInfo.setOutbound(outbound);
					outboundInfo.preUpdate();
					outboundInfoMapper.update(outboundInfo);
				}
			}else{
				outboundInfoMapper.delete(outboundInfo);
			}
		}
		this.delivery(outbound);
	}
	//更新盘亏出库
	@Transactional(readOnly = false)
	public void saveOutbound(Outbound outbound) {
		if(outbound.getNumber() == null || Objects.equals(outbound.getNumber(), "")){
			outbound.setNumber(this.createCKDH());
		}
		super.save(outbound);
		for (OutboundInfo outboundInfo : outbound.getOutboundInfoList()){
			if (outboundInfo.getId() == null){
				continue;
			}
			if (OutboundInfo.DEL_FLAG_NORMAL.equals(outboundInfo.getDelFlag())){
				if (StringUtils.isBlank(outboundInfo.getId())){
					outboundInfo.setOutbound(outbound);
					outboundInfo.preInsert();
					outboundInfoMapper.insert(outboundInfo);
				}else{
					outboundInfo.setOutbound(outbound);
					outboundInfo.preUpdate();
					outboundInfoMapper.update(outboundInfo);
				}
			}else{
				outboundInfoMapper.delete(outboundInfo);
			}
		}
	}
	@Transactional(readOnly = false)
	public void delivery(Outbound outbound) {
		List<OutboundInfo> outboundInfoList = outbound.getOutboundInfoList();
		if(outboundInfoList != null ){
			for (OutboundInfo one:outboundInfoList) {
				String ledgerInfoId = one.getLedgerInfo().getId();
				LedgerInfo ledgerInfo = ledgerInfoMapper.get(ledgerInfoId);
				if(ledgerInfo != null && Objects.equals(ledgerInfo.getDelFlag(), "0")){
					if(ledgerInfo.getQr() != null){
						QrCode qrCode = qrCodeService.get(ledgerInfo.getQr().getId());
						qrCode.setState("3");
						qrCodeService.save(qrCode);
					}
					Ledger ledger = ledgerService.get(ledgerInfo.getLedger().getId());
					ledgerInfoMapper.deleteByLedgerInfo(ledgerInfoId);
					if(ledger != null){
						ledger.setNum(ledger.getNum() - 1);
						try {
							ledger.setSum(ledger.getSum().subtract(ledgerInfo.getAmount()));
						}catch (Exception e){
							System.out.println(e.getMessage());
						}
						ledgerService.lowerLedger(ledger);
					}

				}
			}
		}
	}
	@Transactional(readOnly = false)
	public String createCKDH() {
		String ckdh = CodeUtil.code("CKDH", StaticNumSeq.CKDH);
		return ckdh;
	}
	@Transactional(readOnly = false)
	public void delete(Outbound outbound) {
		super.delete(outbound);
		outboundInfoMapper.delete(new OutboundInfo(outbound));
	}
	@Transactional(readOnly = false)
	public void deleteInfo(Outbound outbound) {
		outboundInfoMapper.deleteByOutboundId(new OutboundInfo(outbound));
	}
	
}