/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.materialrequisition.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

import com.jeeplus.modules.warehouse.code.util.CodeUtil;
import com.jeeplus.modules.warehouse.code.util.StaticNumSeq;
import com.jeeplus.modules.warehouse.ledger.entity.Ledger;
import com.jeeplus.modules.warehouse.ledger.entity.LedgerInfo;
import com.jeeplus.modules.warehouse.ledger.mapper.LedgerInfoMapper;
import com.jeeplus.modules.warehouse.ledger.service.LedgerService;
import com.jeeplus.modules.warehouse.outbound.entity.Outbound;
import com.jeeplus.modules.warehouse.outbound.entity.OutboundInfo;
import com.jeeplus.modules.warehouse.outbound.service.OutboundService;
import com.jeeplus.modules.warehouse.qrcode.entity.QrCode;
import com.jeeplus.modules.warehouse.qrcode.service.QrCodeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jeeplus.core.persistence.Page;
import com.jeeplus.core.service.CrudService;
import com.jeeplus.common.utils.StringUtils;
import com.jeeplus.modules.warehouse.materialrequisition.entity.MaterialRequisition;
import com.jeeplus.modules.warehouse.materialrequisition.mapper.MaterialRequisitionMapper;
import com.jeeplus.modules.warehouse.materialrequisition.entity.MaterialRequisitionInfo;
import com.jeeplus.modules.warehouse.materialrequisition.mapper.MaterialRequisitionInfoMapper;

/**
 * 物资领用Service
 * @author zhanglt
 * @version 2023-02-13
 */
@Service
@Transactional(readOnly = true)
public class MaterialRequisitionService extends CrudService<MaterialRequisitionMapper, MaterialRequisition> {

	@Autowired
	private MaterialRequisitionInfoMapper materialRequisitionInfoMapper;
	@Autowired
	private OutboundService outboundService;
	@Autowired
	private LedgerService ledgerService;
	@Autowired
	private LedgerInfoMapper ledgerInfoMapper;
	@Autowired
	private QrCodeService qrCodeService;


	public MaterialRequisition get(String id) {
		MaterialRequisition materialRequisition = super.get(id);
		materialRequisition.setMaterialRequisitionInfoList(materialRequisitionInfoMapper.findList(new MaterialRequisitionInfo(materialRequisition)));
		return materialRequisition;
	}
	
	public List<MaterialRequisition> findList(MaterialRequisition materialRequisition) {
		return super.findList(materialRequisition);
	}
	
	public Page<MaterialRequisition> findPage(Page<MaterialRequisition> page, MaterialRequisition materialRequisition) {
		return super.findPage(page, materialRequisition);
	}
	
	@Transactional(readOnly = false)
	public void save(MaterialRequisition materialRequisition) {
		materialRequisition.setStatus("1");
		super.save(materialRequisition);
		for (MaterialRequisitionInfo materialRequisitionInfo : materialRequisition.getMaterialRequisitionInfoList()){
			materialRequisitionInfo.setMaterialRequisition(materialRequisition);
			if (materialRequisitionInfo.getId() == null){
				continue;
			}
			if (MaterialRequisitionInfo.DEL_FLAG_NORMAL.equals(materialRequisitionInfo.getDelFlag())){
				if (StringUtils.isBlank(materialRequisitionInfo.getId())){
					materialRequisitionInfo.preInsert();
					materialRequisitionInfoMapper.insert(materialRequisitionInfo);
				}else{
					materialRequisitionInfo.preUpdate();
					materialRequisitionInfoMapper.update(materialRequisitionInfo);
				}
			}else{
				materialRequisitionInfoMapper.delete(materialRequisitionInfo);
			}
		}
	}
	
	@Transactional(readOnly = false)
	public void delete(MaterialRequisition materialRequisition) {
		super.delete(materialRequisition);
		materialRequisitionInfoMapper.delete(new MaterialRequisitionInfo(materialRequisition));
	}
	@Transactional(readOnly = false)
	public String createLYDH() {
		String lydh = CodeUtil.code("LYDH", StaticNumSeq.LYDH);
		return lydh;
	}
	//物资领用后生成 对应的 出库记录
	@Transactional(readOnly = false)
	public void delivery(MaterialRequisition materialRequisition) {
		if(materialRequisition.getNumber() == null &&Objects.equals(materialRequisition.getNumber(), "")){
			materialRequisition.setNumber(this.createLYDH());
		}
		materialRequisition.setStatus("2");
		super.save(materialRequisition);
		Outbound outbound = new Outbound();
		//设置相关表单id为领用主表的ID
		outbound.setRelationId(materialRequisition.getId());
		//查询当前记录是否已经出库
		List<Outbound> list = outboundService.findList(outbound);
		if(list != null && list.size()>0){
			return;
		}
		//设置当 前的操作人 与 发放物资的操作人相同
		outbound.setOperator(materialRequisition.getOperator());
		//当前出库时间
		outbound.setOutboundTime(new Date());
		//出库类型为 领用出库
		outbound.setType("1");
		List<OutboundInfo> outboundInfoList = new ArrayList<>();
		List<MaterialRequisitionInfo> materialRequisitionInfoList = materialRequisition.getMaterialRequisitionInfoList();
		if(materialRequisitionInfoList != null ){
			for (MaterialRequisitionInfo one:materialRequisitionInfoList) {
				OutboundInfo outboundInfo = new OutboundInfo();
				String ledgerInfoId = one.getLedgerInfo().getId();
				LedgerInfo ledgerInfo = ledgerInfoMapper.get(ledgerInfoId);
				ledgerInfoMapper.deleteByLedgerInfo(ledgerInfoId);
				if(ledgerInfo.getQr() != null){
					QrCode qrCode = qrCodeService.get(ledgerInfo.getQr().getId());
					qrCode.setState("3");
					qrCodeService.save(qrCode);
				}
				if(ledgerInfo != null ){
					Ledger ledger = ledgerService.get(ledgerInfo.getLedger().getId());
					if(ledger != null){
						ledger.setNum(ledger.getNum() - 1);
						try {
							ledger.setSum(ledger.getSum().subtract(ledgerInfo.getAmount()));
						}catch (Exception e){
							System.out.println(e.getMessage());
						}
						ledgerService.lowerLedger(ledger);
					}
				}
				outboundInfo.setId("");
				outboundInfo.setOutbound(outbound);
				outboundInfo.setLedgerInfo(one.getLedgerInfo());
				outboundInfoList.add(outboundInfo);
			}
			outbound.setOutboundInfoList(outboundInfoList);
			outboundService.save(outbound);
		}

	}
	
}