/**
 * Copyright &copy; 2015-2020 <a href="http://www.jeeplus.org/">JeePlus</a> All rights reserved.
 */
package com.jeeplus.modules.warehouse.qrcode.mapper;

import com.jeeplus.core.persistence.BaseMapper;
import com.jeeplus.core.persistence.annotation.MyBatisMapper;
import com.jeeplus.modules.warehouse.qrcode.entity.QrCode;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 二维码MAPPER接口
 * @author 胡懿
 * @version 2023-02-13
 */
@MyBatisMapper
public interface QrCodeMapper extends BaseMapper<QrCode> {
    /**
     * 根据货品明细id删除二维码数据
     * @param infoId
     * @return
     */
    public int deleteByGoodInfoId(String infoId);

    /**
     * 根据货品明细id查询二维码集合
     * @param qrCode
     * @return
     */
    public List<QrCode> findByGoodsInfoId(QrCode qrCode);

    /**
     * 根据货品批次号，货品明细类型，货品明细型号，查询二维码信息
     * @param qrCode
     * @return
     */
    public List<QrCode> findByPcTypeModel(QrCode qrCode);
}