package cn.gintone.service;

import cn.gintone.controller.vo.DeviceConnetRuleInfoPageReqVO;
import cn.gintone.controller.vo.DeviceConnetRuleInfoRespVO;
import cn.gintone.controller.vo.DeviceConnetRuleInfoSaveReqVO;
import cn.gintone.dto.DeviceLogInfo;
import cn.gintone.dto.DeviceType;
import cn.gintone.entity.DeviceConnetRuleInfoDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;

import javax.validation.*;
import java.util.List;

/**
 * 设备规则配置细则 Service 接口
 *
 * @author 胡懿
 */
public interface DeviceConnetRuleInfoService {

    /**
     * 创建设备规则配置细则
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createConnetRuleInfo(@Valid DeviceConnetRuleInfoSaveReqVO createReqVO);

    /**
     * 更新设备规则配置细则
     *
     * @param updateReqVO 更新信息
     */
    void updateConnetRuleInfo(@Valid DeviceConnetRuleInfoSaveReqVO updateReqVO);

    /**
     * 删除设备规则配置细则
     *
     * @param id 编号
     */
    void deleteConnetRuleInfo(Long id);

    /**
     * 获得设备规则配置细则
     *
     * @param id 编号
     * @return 设备规则配置细则
     */
    DeviceConnetRuleInfoDO getConnetRuleInfo(Long id);

    /**
     * 获得设备规则配置细则分页
     *
     * @param pageReqVO 分页查询
     * @return 设备规则配置细则分页
     */
    PageResult<DeviceConnetRuleInfoDO> getConnetRuleInfoPage(DeviceConnetRuleInfoPageReqVO pageReqVO);

    /**
     * 获取设备上级信息，并且携带设备信息返回
     * @return
     */
    List<DeviceType> getDeviceType();

    /**
     * 批量添加
     * @param deviceConnetRuleInfoRespVOList
     * @return
     */
    Boolean saveAll(List<DeviceConnetRuleInfoRespVO> deviceConnetRuleInfoRespVOList);

    void deleteByRuleId(Long ruleId);

    Boolean updateAll(List<DeviceConnetRuleInfoRespVO> deviceConnetRuleInfoRespVOList);

    void checkDeviceLogInfo(DeviceLogInfo deviceLogInfo);

    List<DeviceConnetRuleInfoDO> getList(DeviceConnetRuleInfoPageReqVO pageReqVO);
}