package cn.gintone.dal;

import java.util.*;

import cn.gintone.controller.vo.DesCorporationPageReqVO;
import cn.gintone.entity.DesCorporationDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.yudao.framework.mybatis.core.query.LambdaQueryWrapperX;
import org.apache.ibatis.annotations.Mapper;

/**
 * 法人脱敏 Mapper
 *
 * @author 胡懿
 */
@Mapper
public interface DesCorporationMapper extends BaseMapperX<DesCorporationDO> {

    default PageResult<DesCorporationDO> selectPage(DesCorporationPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<DesCorporationDO>()
                .likeIfPresent(DesCorporationDO::getName, reqVO.getName())
                .eqIfPresent(DesCorporationDO::getAttr, reqVO.getAttr())
                .eqIfPresent(DesCorporationDO::getValueOne, reqVO.getValueOne())
                .eqIfPresent(DesCorporationDO::getValueTwo, reqVO.getValueTwo())
                .eqIfPresent(DesCorporationDO::getValueThree, reqVO.getValueThree())
                .betweenIfPresent(DesCorporationDO::getCreateTime, reqVO.getCreateTime())
                .eqIfPresent(DesCorporationDO::getRule, reqVO.getRule())
                .orderByDesc(DesCorporationDO::getId));
    }

}