package cn.gintone.service;

import cn.gintone.ErrorInfo;
import cn.gintone.controller.vo.DeviceTypePageReqVO;
import cn.gintone.controller.vo.DeviceTypeSaveReqVO;
import cn.gintone.dal.DeviceTypeMapper;
import cn.gintone.entity.DeviceTypeDO;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.common.pojo.PageParam;
import cn.iocoder.yudao.framework.common.util.object.BeanUtils;


import static cn.iocoder.yudao.framework.common.exception.util.ServiceExceptionUtil.exception;

/**
 * 设备类型 Service 实现类
 *
 * @author 安全系统管理
 */
@Service
@Validated
public class DeviceTypeServiceImpl implements DeviceTypeService {

    @Resource
    private DeviceTypeMapper deviceTypeMapper;

    @Override
    public Long createDeviceType(DeviceTypeSaveReqVO createReqVO) {
        // 插入
        DeviceTypeDO deviceType = BeanUtils.toBean(createReqVO, DeviceTypeDO.class);
        deviceTypeMapper.insert(deviceType);
        // 返回
        return deviceType.getId();
    }

    @Override
    public void updateDeviceType(DeviceTypeSaveReqVO updateReqVO) {
        // 校验存在
        validateDeviceTypeExists(updateReqVO.getId());
        // 更新
        DeviceTypeDO updateObj = BeanUtils.toBean(updateReqVO, DeviceTypeDO.class);
        deviceTypeMapper.updateById(updateObj);
    }

    @Override
    public void deleteDeviceType(Long id) {
        // 校验存在
        validateDeviceTypeExists(id);
        // 删除
        deviceTypeMapper.deleteById(id);
    }

    private void validateDeviceTypeExists(Long id) {
        if (deviceTypeMapper.selectById(id) == null) {
            throw exception(ErrorInfo.DEVICE_TYPE_NOT_EXISTS);
        }
    }

    @Override
    public DeviceTypeDO getDeviceType(Long id) {
        return deviceTypeMapper.selectById(id);
    }

    @Override
    public PageResult<DeviceTypeDO> getDeviceTypePage(DeviceTypePageReqVO pageReqVO) {
        return deviceTypeMapper.selectPage(pageReqVO);
    }

}