package cn.gintone.entity;

import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.yudao.framework.mybatis.core.dataobject.BaseDO;

/**
 * 法人脱敏 DO
 *
 * @author 胡懿
 */
@TableName("t_des_corporation")
@KeySequence("t_des_corporation_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DesCorporationDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 属性名称
     */
    private String name;
    /**
     * 属性描述
     */
    private String attr;
    /**
     * 配置1
     */
    private String valueOne;
    /**
     * 配置2
     */
    private String valueTwo;
    /**
     * 配置3
     */
    private String valueThree;
    /**
     * 规则
     */
    private Integer rule;

}