package cn.gintone.controller.vo;

import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.yudao.framework.common.pojo.PageParam;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.yudao.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 人员脱敏规则分页 Request VO")
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class UserDesRulePageReqVO extends PageParam {

    @Schema(description = "属性名称", example = "李四")
    private String name;

    @Schema(description = "属性描述")
    private String attr;

    @Schema(description = "规则")
    private Integer rule;

    @Schema(description = "配置项1")
    private String valueOne;

    @Schema(description = "配置项2")
    private String valueTwo;

    @Schema(description = "配置项3")
    private String valueThree;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

}