package cn.gintone.controller.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import javax.validation.constraints.*;

@Schema(description = "管理后台 - 设备类型新增/修改 Request VO")
@Data
public class DeviceTypeSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "3316")
    private Long id;

    @Schema(description = "设备类型名称", example = "赵六")
    private String name;

    @Schema(description = "设备类型标识")
    private String modelCode;

    @Schema(description = "厂家设备类型标识")
    private String manufacturer;

    @Schema(description = "所属集成应用")
    private String integratedApplicationOwnership;

}