package cn.gintone.controller;

import cn.gintone.config.IotDbConfig;
import cn.gintone.dto.WebIllLogInfo;
import cn.gintone.dto.WebLogInfo;
import cn.gintone.dto.WebLogInfoVo;
import cn.gintone.iotdbUtils.*;
import cn.iocoder.yudao.framework.common.pojo.CommonResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.annotation.security.PermitAll;
import java.util.Date;
import java.util.List;

@RestController
@RequestMapping("/admin-api/gintone/webLogInfo")
public class WebLogInfoController {

    @Autowired
    @Qualifier("kafkaTemplate1")
    private KafkaTemplate<String,String> kafkaTemplate1;


    @Autowired
    @Qualifier("kafkaTemplate2")
    private KafkaTemplate<String,String> kafkaTemplate2;

    @Autowired
    private IotDbConfig iotDbConfig;

    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @PermitAll
    @PostMapping("/initIotDBDatabase")
    @Operation(summary = "初始化数据库")
    public CommonResult<String> initIotDBDatabase() {
//        MyIotDbUtils.createDatabase(iotDbConfig);
        MyIotDbUtils.createWebLogInfoTimeseries(iotDbConfig);
        MyIotDbUtils.createIllegalLogTimeseries(iotDbConfig);
        FileIotDbUtil.createFileLogInfoTimeseries(iotDbConfig);
        SpecialPeopleIotDbUtils.createSpeLogInfoTimeseries(iotDbConfig);

        MyIotDbUtils.createDeviceLogInfoTimeseries(iotDbConfig);
        MyIotDbUtils.createDeviceIllLogInfoTimeseries(iotDbConfig);

        JarDecLogIotDbUtil.createJarDecLogInfoTimeseries(iotDbConfig);


        // delete timeseries root.myWebLogInfo.**
        // delete timeseries root.myDeviceLogInfo.**
        // delete timeseries root.myDecFileLogInfo.**

        return CommonResult.success("初始化成功");
    }


    @PermitAll
    @PostMapping("/testKafkaTemplateTwo")
    @Operation(summary = "测试第二个kafka消息")
    public CommonResult<String> testKafkaTemplateTwo() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("serialNo", "14010000002001000300");
        kafkaTemplate2.send("BZHSZM_JCSJ",jsonObject.toJSONString());
        return CommonResult.success("保存成功");
    }


    @PermitAll
    @PostMapping("/saveWebLogInfo")
    @Operation(summary = "外部性请求保存日志")
    public CommonResult<String> saveWebLogInfo(@RequestBody WebLogInfo webLogInfo) {
        if (null == webLogInfo.getAccessed()) {
            webLogInfo.setAccessed(MyDateUtils.longToString(new Date().getTime()));
        }
        String webLogInfoStr = JSON.toJSONString(webLogInfo);
//        rabbitTemplate.convertAndSend("my_boot_topic_exchange", "weblog.save", webLogInfoStr);
        kafkaTemplate1.send("weblog.save",webLogInfoStr);
        return CommonResult.success("保存成功");
    }

    @GetMapping("/countWebLogInfo")
    @Operation(summary = "统计日志条数接口")
    public CommonResult<Long> countWebLogInfo(WebLogInfoVo webLogInfoVo) {
        long pageCount = MyIotDbUtils.countWebInfo(iotDbConfig, webLogInfoVo);
        return CommonResult.success(pageCount);
    }

    @GetMapping("/webLogInfoList")
    @Operation(summary = "查询接口日志接口")
    public CommonResult<List<WebLogInfo>> webLogInfoList(WebLogInfoVo webLogInfoVo) {
        List<WebLogInfo> webLogInfoList = MyIotDbUtils.selectWebInfo(iotDbConfig, webLogInfoVo);
        return CommonResult.success(webLogInfoList);
    }

    @GetMapping("/webLogInfoWarningList")
    @Operation(summary = "查询警告接口日志接口")
    public CommonResult<List<WebLogInfo>> webLogInfoWarningList(WebLogInfoVo webLogInfoVo) {
        webLogInfoVo.setType("warning");
        List<WebLogInfo> webLogInfoList = MyIotDbUtils.selectWebInfo(iotDbConfig, webLogInfoVo);
        return CommonResult.success(webLogInfoList);
    }

    @GetMapping("/webLogInfoErrorList")
    @Operation(summary = "查询警告接口日志接口")
    public CommonResult<List<WebLogInfo>> webLogInfoErrorList(WebLogInfoVo webLogInfoVo) {
        webLogInfoVo.setType("error");
        List<WebLogInfo> webLogInfoList = MyIotDbUtils.selectWebInfo(iotDbConfig, webLogInfoVo);
        return CommonResult.success(webLogInfoList);
    }

    @GetMapping("/countWebIllLogInfo")
    @Operation(summary = "统计非法日志条数接口")
    public CommonResult<Long> countWebIllLogInfo(WebLogInfoVo webLogInfoVo) {

        String s = stringRedisTemplate.opsForValue().get("pdToken");
        System.out.println(s);
        System.out.println(123);

        long pageCount = MyIotDbUtils.countWebIllInfo(iotDbConfig, webLogInfoVo);
        return CommonResult.success(pageCount);
    }

    @GetMapping("/webIllLogInfoList")
    @Operation(summary = "查询非法日志记录")
    public CommonResult<List<WebIllLogInfo>> webIllLogInfoList(WebLogInfoVo webLogInfoVo) {
        List<WebIllLogInfo> webIllLogInfos = MyIotDbUtils.selectWebIllInfo(iotDbConfig, webLogInfoVo);
        return CommonResult.success(webIllLogInfos);
    }
}
