package cn.gintone.service;

import java.util.*;
import javax.validation.*;

import cn.gintone.controller.vo.DeviceTypePageReqVO;
import cn.gintone.controller.vo.DeviceTypeSaveReqVO;
import cn.gintone.entity.DeviceTypeDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.common.pojo.PageParam;

/**
 * 设备类型 Service 接口
 *
 * @author 安全系统管理
 */
public interface DeviceTypeService {

    /**
     * 创建设备类型
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createDeviceType(@Valid DeviceTypeSaveReqVO createReqVO);

    /**
     * 更新设备类型
     *
     * @param updateReqVO 更新信息
     */
    void updateDeviceType(@Valid DeviceTypeSaveReqVO updateReqVO);

    /**
     * 删除设备类型
     *
     * @param id 编号
     */
    void deleteDeviceType(Long id);

    /**
     * 获得设备类型
     *
     * @param id 编号
     * @return 设备类型
     */
    DeviceTypeDO getDeviceType(Long id);

    /**
     * 获得设备类型分页
     *
     * @param pageReqVO 分页查询
     * @return 设备类型分页
     */
    PageResult<DeviceTypeDO> getDeviceTypePage(DeviceTypePageReqVO pageReqVO);

}