package cn.gintone.entity;

import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.yudao.framework.mybatis.core.dataobject.BaseDO;

/**
 * 设备类型 DO
 *
 * @author 安全系统管理
 */
@TableName("t_device_type")
@KeySequence("t_device_type_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DeviceTypeDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 设备类型名称
     */
    private String name;
    /**
     * 设备类型标识
     */
    private String modelCode;
    /**
     * 厂家设备类型标识
     */
    private String manufacturer;
    /**
     * 所属集成应用
     */
    private String integratedApplicationOwnership;

}