package cn.gintone.dal;


import cn.gintone.controller.vo.MyTablePageReqVO;
import cn.gintone.entity.MyTableDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.yudao.framework.mybatis.core.query.LambdaQueryWrapperX;
import org.apache.ibatis.annotations.Mapper;

/**
 * 我的测试表 Mapper
 *
 * @author 胡懿
 */
@Mapper
public interface MyTableMapper extends BaseMapperX<MyTableDO> {

    default PageResult<MyTableDO> selectPage(MyTablePageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<MyTableDO>()
                .likeIfPresent(MyTableDO::getName, reqVO.getName())
                .eqIfPresent(MyTableDO::getAge, reqVO.getAge())
                .eqIfPresent(MyTableDO::getMoney, reqVO.getMoney())
                .orderByDesc(MyTableDO::getId));
    }

}