package cn.gintone.controller.vo;

import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.yudao.framework.common.pojo.PageParam;
import java.time.LocalDateTime;
import org.springframework.format.annotation.DateTimeFormat;

import static cn.iocoder.yudao.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 物联网设备请求配置列表 Request VO")
@Data
public class DeviceReqConfListReqVO {

    @Schema(description = "设备名称", example = "张三")
    private String deviceName;

    @Schema(description = "设备id", example = "21048")
    private String deviceId;

    @Schema(description = "设备类型id", example = "24373")
    private Long deviceTypeId;

    @Schema(description = "父级id", example = "31343")
    private Long parentId;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;


    private String snCode; // sn
    private String address; // 地址
    private String deviceEn; // 设备英文
    private String regionName; // 区域名称
    private String deviceTypeName;
    private Integer state; // 设备状态
    private Date sycnDate; // 设备状态监测时间
}