package cn.gintone.service;


import cn.gintone.controller.vo.WebReqConfSaveReqVO;
import cn.gintone.dal.SysAbbreMapper;
import cn.gintone.dtoPt.PtData;
import cn.gintone.dtoPt.PtMenuInfo;
import cn.gintone.entity.SysAbbreDO;
import cn.gintone.myconf.BasicUrlConf;
import cn.gintone.utils.BasicInfoHttpUtils;
import cn.iocoder.yudao.module.system.controller.admin.auth.myVo.PtResult;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

@Component
public class PtTimeTaskService {

    @Resource
    private BasicUrlConf basicUrlConf;
    @Autowired
    private WebReqConfService webReqConfService;
    @Autowired
    private SysAbbreMapper sysAbbreMapper;

    @Scheduled(fixedDelay = 10000)
    public void executeEvery5Minutes() {
        SysAbbreDO secure = sysAbbreMapper.selectOne(new QueryWrapper<SysAbbreDO>()
                .lambda()
                .eq(SysAbbreDO::getAbbreEn, "SLPT")
        );
        PtResult<PtData<PtMenuInfo>> ptMenuList = BasicInfoHttpUtils.getPtMenu(basicUrlConf.getMenuInfoUrl(), "", "");
        PtData<PtMenuInfo> data = ptMenuList.getData();
        if (data != null) {
            List<PtMenuInfo> rowDataList = data.getRowData();
            if (rowDataList != null && rowDataList.size() > 0) {
                for (PtMenuInfo rowData : rowDataList) {
                    String pValue = rowData.getP_VALUE();
                    if (pValue != null && pValue.length() > 1) {
                        WebReqConfSaveReqVO webReqConfSaveReqVO = new WebReqConfSaveReqVO();
                        webReqConfSaveReqVO.setApiUrl(pValue);
                        webReqConfSaveReqVO.setApiId(rowData.getP_ID() + "");
                        if (null != rowData.getPARENT_P_ID()) {
                            webReqConfSaveReqVO.setApiParentId(rowData.getPARENT_P_ID() + "");
                        }
                        webReqConfSaveReqVO.setApiName(rowData.getP_NAME());
                        webReqConfSaveReqVO.setAbbreId(secure.getId());
                        webReqConfSaveReqVO.setAbbreCn(secure.getAbbreCn());
                        webReqConfService.myCreateWebReqConf(webReqConfSaveReqVO);
                    }
                }
            }
        }
        System.out.println(123);
    }
}
