package cn.gintone.iotdbUtils;

import cn.gintone.config.IotDbConfig;
import cn.gintone.dto.*;
import org.apache.iotdb.isession.pool.SessionDataSetWrapper;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.RowRecord;
import org.springframework.util.StringUtils;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;

public class MyIotDbUtils {

    // 创建数据库
    public static void createDatabase(IotDbConfig iotDbConfig) {
        // Using nodeUrls ensures that when one node goes down, other nodes are automatically connected to retry
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            SessionPool sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            sessionPool.createDatabase("root.myWebLogInfo"); // 创建数据库
            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void createWebLogInfoTimeseries(IotDbConfig iotDbConfig) {
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            SessionPool sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            // 设置数据类型，设置默认编码模式，设置默认压缩模式
            sessionPool.createTimeseries("root.myWebLogInfo.tableTwo.userId", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableTwo.username", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableTwo.sysAbbre", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableTwo.url", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableTwo.accessed", TSDataType.TIMESTAMP, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableTwo.type", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableTwo.clientIp", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableTwo.remark", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }
    }


    public static void createIllegalLogTimeseries(IotDbConfig iotDbConfig) {
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            SessionPool sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            // 设置数据类型，设置默认编码模式，设置默认压缩模式
            sessionPool.createTimeseries("root.myWebLogInfo.tableThree.userId", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableThree.username", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableThree.sysAbbre", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableThree.url", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableThree.accessed", TSDataType.TIMESTAMP, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableThree.type", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableThree.clientIp", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableThree.remark", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myWebLogInfo.tableThree.illType", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    // 访问日志单行插入
    public static void inserOne(IotDbConfig iotDbConfig, WebLogInfo webLogInfo) {
        if (null == webLogInfo) {
            return;
        }
        // Using nodeUrls ensures that when one node goes down, other nodes are automatically connected to retry
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            SessionPool sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            List<String> list5 = new ArrayList<>();
            list5.add("userId");
            list5.add("username");
            list5.add("sysAbbre");
            list5.add("url");
            list5.add("accessed");
            list5.add("type");
            list5.add("clientIp");
            list5.add("remark");

            List<TSDataType> list6 = new ArrayList<>();
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TIMESTAMP);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);

            List<Object> values = new ArrayList<>();
            values.add(webLogInfo.getUserId());
            values.add(webLogInfo.getUsername());
            values.add(webLogInfo.getSysAbbre());
            values.add(webLogInfo.getUrl());
            values.add(MyDateUtils.stringToLong(webLogInfo.getAccessed()));
            values.add(webLogInfo.getType());
            values.add(webLogInfo.getClientIp());
            values.add(webLogInfo.getRemark());
            sessionPool.insertRecord("root.myWebLogInfo.tableTwo", System.currentTimeMillis(), list5, list6, values);
            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    // 非法访问日志单行插入
    public static void inserOne_Ill(IotDbConfig iotDbConfig, WebIllLogInfo webIllLogInfo) {
        if (null == webIllLogInfo) {
            return;
        }
        // Using nodeUrls ensures that when one node goes down, other nodes are automatically connected to retry
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            SessionPool sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            List<String> list5 = new ArrayList<>();
            list5.add("userId");
            list5.add("username");
            list5.add("sysAbbre");
            list5.add("url");
            list5.add("accessed");
            list5.add("type");
            list5.add("clientIp");
            list5.add("remark");
            list5.add("illType");

            List<TSDataType> list6 = new ArrayList<>();
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TIMESTAMP);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);

            List<Object> values = new ArrayList<>();
            values.add(webIllLogInfo.getUserId());
            values.add(webIllLogInfo.getUsername());
            values.add(webIllLogInfo.getSysAbbre());
            values.add(webIllLogInfo.getUrl());
            values.add(MyDateUtils.stringToLong(webIllLogInfo.getAccessed()));
            values.add(webIllLogInfo.getType());
            values.add(webIllLogInfo.getClientIp());
            values.add(webIllLogInfo.getRemark());
            values.add(webIllLogInfo.getIllType());
            sessionPool.insertRecord("root.myWebLogInfo.tableThree", System.currentTimeMillis(), list5, list6, values);
            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }
    }


    // 查询总条数
    public static long countWebInfo(IotDbConfig iotDbConfig, WebLogInfoVo webLogInfoVo) {
        long num = 0;
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            SessionPool sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();


            StringBuffer sb = new StringBuffer();
            sb.append("select count(userId) from root.myWebLogInfo.tableTwo");
            if ((null != webLogInfoVo.getEndTime() && 0 != webLogInfoVo.getEndTime())
                    || (null != webLogInfoVo.getBeginTime() && 0 != webLogInfoVo.getBeginTime())
                    || (null != webLogInfoVo.getType() && !"".equals(webLogInfoVo.getType()))
                    || (null != webLogInfoVo.getSysAbbre() && !"".equals(webLogInfoVo.getSysAbbre()))) {
                sb.append(" where");
                boolean needAnd = false;
                if (null != webLogInfoVo.getEndTime() && 0 != webLogInfoVo.getEndTime() ) {
                    needAnd = true;
                    sb.append(" accessed <= "+ webLogInfoVo.getEndTime());
                }
                if (null != webLogInfoVo.getBeginTime() && 0 != webLogInfoVo.getBeginTime()) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" accessed >= "+ webLogInfoVo.getBeginTime());

                }
                if (null != webLogInfoVo.getType() && !"".equals(webLogInfoVo.getType())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" type = '" + webLogInfoVo.getType() + "'");
                }
                if (null != webLogInfoVo.getSysAbbre() && !"".equals(webLogInfoVo.getSysAbbre())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" sysAbbre = " + "'" +webLogInfoVo.getSysAbbre() + "'");
                }
            }
            String sql = sb.toString();
            System.out.println(sql);
            SessionDataSetWrapper sessionDataSetWrapper = sessionPool.executeQueryStatement(sql);
            List<String> columnNames = sessionDataSetWrapper.getColumnNames();
            System.out.println(columnNames);
            while (sessionDataSetWrapper.hasNext()) {
                RowRecord next = sessionDataSetWrapper.next(); // 取出一行数据
                long timestamp = next.getTimestamp(); // 获取这行的时间戳
                List<Field> fields = next.getFields();
                Field field0 = fields.get(0);
                num = field0.getLongV();
            }

            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }

        return num;
    }

    // 查询列表
    public static List<WebLogInfo> selectWebInfo(IotDbConfig iotDbConfig, WebLogInfoVo webLogInfoVo) {
        List<WebLogInfo> webLogInfos = new ArrayList<>();
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            SessionPool sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            int offsetNum = (webLogInfoVo.getPageNum() - 1) * webLogInfoVo.getPageSize();
            int limitNum = webLogInfoVo.getPageSize();
            StringBuffer sb = new StringBuffer();
            sb.append("select userId, username, sysAbbre, url, accessed, type, clientIp, remark from root.myWebLogInfo.tableTwo");
            if ((null != webLogInfoVo.getEndTime() && 0 != webLogInfoVo.getEndTime())
                    || (null != webLogInfoVo.getBeginTime() && 0 != webLogInfoVo.getBeginTime())
                    || (null != webLogInfoVo.getType() && !"".equals(webLogInfoVo.getType()))
                    || (null != webLogInfoVo.getSysAbbre() && !"".equals(webLogInfoVo.getSysAbbre()))) {
                sb.append(" where");
                boolean needAnd = false;
                if (null != webLogInfoVo.getEndTime() && 0 != webLogInfoVo.getEndTime() ) {
                    needAnd = true;
                    sb.append(" accessed <= "+ webLogInfoVo.getEndTime());
                }
                if (null != webLogInfoVo.getBeginTime() && 0 != webLogInfoVo.getBeginTime()) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" accessed >= "+ webLogInfoVo.getBeginTime());

                }
                if (null != webLogInfoVo.getType() && !"".equals(webLogInfoVo.getType())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" type = '" + webLogInfoVo.getType() + "'");
                }
                if (null != webLogInfoVo.getSysAbbre() && !"".equals(webLogInfoVo.getSysAbbre())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" sysAbbre = " + "'" +webLogInfoVo.getSysAbbre() + "'");
                }
            }
            sb.append(" order by time desc offset " + offsetNum + " limit " + limitNum);
            String sql = sb.toString();
            System.out.println(sql);
            SessionDataSetWrapper sessionDataSetWrapper = sessionPool.executeQueryStatement(sql);
            List<String> columnNames = sessionDataSetWrapper.getColumnNames();
            System.out.println(columnNames);
            while (sessionDataSetWrapper.hasNext()) {
                RowRecord next = sessionDataSetWrapper.next(); // 取出一行数据
                long timestamp = next.getTimestamp(); // 获取这行的时间戳
                List<Field> fields = next.getFields();
                Field field0 = fields.get(0);
                String userId = field0.getStringValue();
                Field field1 = fields.get(1);
                String username = field1.getStringValue();
                Field field2 = fields.get(2);
                String sysAbbre = field2.getStringValue();
                Field field3 = fields.get(3);
                String url = field3.getStringValue();
                Field field4 = fields.get(4);
                long accessed = field4.getLongV();
                Field field5 = fields.get(5);
                String type = field5.getStringValue();
                Field field6 = fields.get(6);
                String clientIp = field6.getStringValue();
                Field field7 = fields.get(7);
                String remark = field7.getStringValue();

                WebLogInfo webLogInfo = new WebLogInfo();
                webLogInfo.setTimesta(timestamp);
                webLogInfo.setTimestaStr(MyDateUtils.longToString(timestamp));
                webLogInfo.setUserId(userId);
                webLogInfo.setUsername(username);
                webLogInfo.setSysAbbre(sysAbbre);
                webLogInfo.setUrl(url);
                webLogInfo.setAccessed(MyDateUtils.longToString(accessed));
                webLogInfo.setType(type);
                webLogInfo.setClientIp(clientIp);
                webLogInfo.setRemark(remark);
                webLogInfos.add(webLogInfo);
            }

            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }

        return webLogInfos;
    }


    // 查询总条数
    public static long countWebIllInfo(IotDbConfig iotDbConfig, WebLogInfoVo webLogInfoVo) {
        long num = 0;
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            SessionPool sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();


            StringBuffer sb = new StringBuffer();
            sb.append("select count(userId) from root.myWebLogInfo.tableThree");
            if ((null != webLogInfoVo.getEndTime() && 0 != webLogInfoVo.getEndTime())
                    || (null != webLogInfoVo.getBeginTime() && 0 != webLogInfoVo.getBeginTime())
                    || (null != webLogInfoVo.getType() && !"".equals(webLogInfoVo.getType()))
                    || (null != webLogInfoVo.getSysAbbre() && !"".equals(webLogInfoVo.getSysAbbre()))) {
                sb.append(" where");
                boolean needAnd = false;
                if (null != webLogInfoVo.getEndTime() && 0 != webLogInfoVo.getEndTime() ) {
                    needAnd = true;
                    sb.append(" accessed <= "+ webLogInfoVo.getEndTime());
                }
                if (null != webLogInfoVo.getBeginTime() && 0 != webLogInfoVo.getBeginTime()) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" accessed >= "+ webLogInfoVo.getBeginTime());

                }
                if (null != webLogInfoVo.getType() && !"".equals(webLogInfoVo.getType())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" type = '" + webLogInfoVo.getType() + "'");
                }
                if (null != webLogInfoVo.getSysAbbre() && !"".equals(webLogInfoVo.getSysAbbre())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" sysAbbre = " + "'" +webLogInfoVo.getSysAbbre() + "'");
                }
                if (null != webLogInfoVo.getIllType() && !"".equals(webLogInfoVo.getIllType())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" illType = " + "'" +webLogInfoVo.getIllType() + "'");
                }
            }
            String sql = sb.toString();
            System.out.println(sql);
            SessionDataSetWrapper sessionDataSetWrapper = sessionPool.executeQueryStatement(sql);
            List<String> columnNames = sessionDataSetWrapper.getColumnNames();
            System.out.println(columnNames);
            while (sessionDataSetWrapper.hasNext()) {
                RowRecord next = sessionDataSetWrapper.next(); // 取出一行数据
                long timestamp = next.getTimestamp(); // 获取这行的时间戳
                List<Field> fields = next.getFields();
                Field field0 = fields.get(0);
                num = field0.getLongV();
            }

            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }

        return num;
    }

    public static List<WebIllLogInfo> selectWebIllInfo(IotDbConfig iotDbConfig, WebLogInfoVo webLogInfoVo) {
        List<WebIllLogInfo> webIllLogInfos = new ArrayList<>();
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            SessionPool sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            int offsetNum = (webLogInfoVo.getPageNum() - 1) * webLogInfoVo.getPageSize();
            int limitNum = webLogInfoVo.getPageSize();
            StringBuffer sb = new StringBuffer();
            sb.append("select userId, username, sysAbbre, url, accessed, type, clientIp, remark, illType from root.myWebLogInfo.tableThree");
            if ((null != webLogInfoVo.getEndTime() && 0 != webLogInfoVo.getEndTime())
                    || (null != webLogInfoVo.getBeginTime() && 0 != webLogInfoVo.getBeginTime())
                    || (null != webLogInfoVo.getType() && !"".equals(webLogInfoVo.getType()))
                    || (null != webLogInfoVo.getSysAbbre() && !"".equals(webLogInfoVo.getSysAbbre()))) {
                sb.append(" where");
                boolean needAnd = false;
                if (null != webLogInfoVo.getEndTime() && 0 != webLogInfoVo.getEndTime() ) {
                    needAnd = true;
                    sb.append(" accessed <= "+ webLogInfoVo.getEndTime());
                }
                if (null != webLogInfoVo.getBeginTime() && 0 != webLogInfoVo.getBeginTime()) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" accessed >= "+ webLogInfoVo.getBeginTime());

                }
                if (null != webLogInfoVo.getType() && !"".equals(webLogInfoVo.getType())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" type = '" + webLogInfoVo.getType() + "'");
                }
                if (null != webLogInfoVo.getSysAbbre() && !"".equals(webLogInfoVo.getSysAbbre())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" sysAbbre = " + "'" +webLogInfoVo.getSysAbbre() + "'");
                }
                if (null != webLogInfoVo.getIllType() && !"".equals(webLogInfoVo.getIllType())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" illType = " + "'" +webLogInfoVo.getIllType() + "'");
                }
            }
            sb.append(" order by time desc offset " + offsetNum + " limit " + limitNum);
            String sql = sb.toString();
            System.out.println(sql);
            SessionDataSetWrapper sessionDataSetWrapper = sessionPool.executeQueryStatement(sql);
            List<String> columnNames = sessionDataSetWrapper.getColumnNames();
            System.out.println(columnNames);
            while (sessionDataSetWrapper.hasNext()) {
                RowRecord next = sessionDataSetWrapper.next(); // 取出一行数据
                long timestamp = next.getTimestamp(); // 获取这行的时间戳
                List<Field> fields = next.getFields();
                Field field0 = fields.get(0);
                String userId = field0.getStringValue();
                Field field1 = fields.get(1);
                String username = field1.getStringValue();
                Field field2 = fields.get(2);
                String sysAbbre = field2.getStringValue();
                Field field3 = fields.get(3);
                String url = field3.getStringValue();
                Field field4 = fields.get(4);
                long accessed = field4.getLongV();
                Field field5 = fields.get(5);
                String type = field5.getStringValue();
                Field field6 = fields.get(6);
                String clientIp = field6.getStringValue();
                Field field7 = fields.get(7);
                String remark = field7.getStringValue();
                Field field8 = fields.get(8);
                String illType = field8.getStringValue();

                WebIllLogInfo webIllLogInfo = new WebIllLogInfo();
                webIllLogInfo.setTimesta(timestamp);
                webIllLogInfo.setTimestaStr(MyDateUtils.longToString(timestamp));
                webIllLogInfo.setUserId(userId);
                webIllLogInfo.setUsername(username);
                webIllLogInfo.setSysAbbre(sysAbbre);
                webIllLogInfo.setUrl(url);
                webIllLogInfo.setAccessed(MyDateUtils.longToString(accessed));
                webIllLogInfo.setType(type);
                webIllLogInfo.setClientIp(clientIp);
                webIllLogInfo.setRemark(remark);
                webIllLogInfo.setIllType(illType);
                webIllLogInfos.add(webIllLogInfo);
            }

            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }

        return webIllLogInfos;
    }


    // ---------------------设备日志
    // 初始化设备访问日志时间序列
    public static void createDeviceLogInfoTimeseries(IotDbConfig iotDbConfig) {
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            SessionPool sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            // 设置数据类型，设置默认编码模式，设置默认压缩模式
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableOne.roleId", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableOne.roleName", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableOne.userId", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableOne.username", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableOne.deviceId", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableOne.deviceName", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableOne.deviceTypeId", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableOne.deviceTypeName", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableOne.deviceSn", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableOne.accessed", TSDataType.TIMESTAMP, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableOne.type", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableOne.clientIp", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableOne.remark", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }
    }
    // 创建设备非法访问时间序列
    public static void createDeviceIllLogInfoTimeseries(IotDbConfig iotDbConfig) {
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            SessionPool sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            // 设置数据类型，设置默认编码模式，设置默认压缩模式
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableTwo.roleId", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableTwo.roleName", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableTwo.userId", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableTwo.username", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableTwo.deviceId", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableTwo.deviceName", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableTwo.deviceTypeId", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableTwo.deviceTypeName", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableTwo.deviceSn", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableTwo.accessed", TSDataType.TIMESTAMP, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableTwo.illType", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableTwo.clientIp", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.createTimeseries("root.myDeviceLogInfo.tableTwo.remark", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED);
            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    // 添加设备访问日志
    public static void inserOneDeviceLogInfo(IotDbConfig iotDbConfig, DeviceLogInfo deviceLogInfo) {
        if (null == deviceLogInfo) {
            return;
        }
        // Using nodeUrls ensures that when one node goes down, other nodes are automatically connected to retry
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            SessionPool sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            /**
             *     private Long   timesta;
             *     private String timestaStr;
             *     private String roleId;
             *     private String roleName;
             *     private String userId; // 用户id
             *     private String username; // 用户名
             *     private String deviceId; // 设备id
             *     private String deviceName; // 设备名称
             *     private String deviceTypeId; // 设备类型id
             *     private String deviceTypeName; // 设备类型名称
             *     private String accessed; // 访问时间
             *     private String type; // 日志类型(info, warning, error)
             *     private String clientIp; // 访问端ip
             *     private String remark; // 备注
             */

            List<String> list5 = new ArrayList<>();
            list5.add("roleId");
            list5.add("roleName");
            list5.add("userId");
            list5.add("username");
            list5.add("deviceId");
            list5.add("deviceName");
            list5.add("deviceTypeId");
            list5.add("deviceTypeName");
            list5.add("deviceSn");
            list5.add("accessed");
            list5.add("type");
            list5.add("clientIp");
            list5.add("remark");

            List<TSDataType> list6 = new ArrayList<>();
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TIMESTAMP);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);

            List<Object> values = new ArrayList<>();
            values.add(deviceLogInfo.getRoleId());
            values.add(deviceLogInfo.getRoleName());
            values.add(deviceLogInfo.getUserId());
            values.add(deviceLogInfo.getUsername());
            values.add(deviceLogInfo.getDeviceId());
            values.add(deviceLogInfo.getDeviceName());
            values.add(deviceLogInfo.getDeviceTypeId());
            values.add(deviceLogInfo.getDeviceTypeName());
            values.add(deviceLogInfo.getDeviceSn());
            values.add(MyDateUtils.stringToLong(deviceLogInfo.getAccessed()));
            values.add(deviceLogInfo.getType());
            values.add(deviceLogInfo.getClientIp());
            values.add(deviceLogInfo.getRemark());
            sessionPool.insertRecord("root.myDeviceLogInfo.tableOne", System.currentTimeMillis(), list5, list6, values);
            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }
    }
    // 添加设备非法访问日志
    public static void inserOneDeviceLogInfo_ill(IotDbConfig iotDbConfig, DeviceIllLogInfo deviceIllLogInfo) {
        if (null == deviceIllLogInfo) {
            return;
        }
        // Using nodeUrls ensures that when one node goes down, other nodes are automatically connected to retry
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            SessionPool sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            /**
             *     private Long   timesta;
             *     private String timestaStr;
             *     private String roleId;
             *     private String roleName;
             *     private String userId; // 用户id
             *     private String username; // 用户名
             *     private String deviceId; // 设备id
             *     private String deviceName; // 设备名称
             *     private String deviceTypeId; // 设备类型id
             *     private String deviceTypeName; // 设备类型名称
             *     private String accessed; // 访问时间
             *     private String type; // 日志类型(info, warning, error)
             *     private String clientIp; // 访问端ip
             *     private String remark; // 备注
             */

            List<String> list5 = new ArrayList<>();
            list5.add("roleId");
            list5.add("roleName");
            list5.add("userId");
            list5.add("username");
            list5.add("deviceId");
            list5.add("deviceName");
            list5.add("deviceTypeId");
            list5.add("deviceTypeName");
            list5.add("deviceSn");
            list5.add("accessed");
            list5.add("illType");
            list5.add("clientIp");
            list5.add("remark");

            List<TSDataType> list6 = new ArrayList<>();
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TIMESTAMP);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);
            list6.add(TSDataType.TEXT);

            List<Object> values = new ArrayList<>();
            values.add(deviceIllLogInfo.getRoleId());
            values.add(deviceIllLogInfo.getRoleName());
            values.add(deviceIllLogInfo.getUserId());
            values.add(deviceIllLogInfo.getUsername());
            values.add(deviceIllLogInfo.getDeviceId());
            values.add(deviceIllLogInfo.getDeviceName());
            values.add(deviceIllLogInfo.getDeviceTypeId());
            values.add(deviceIllLogInfo.getDeviceTypeName());
            values.add(deviceIllLogInfo.getDeviceSn());
            values.add(MyDateUtils.stringToLong(deviceIllLogInfo.getAccessed()));
            values.add(deviceIllLogInfo.getIllType());
            values.add(deviceIllLogInfo.getClientIp());
            values.add(deviceIllLogInfo.getRemark());
            sessionPool.insertRecord("root.myDeviceLogInfo.tableTwo", System.currentTimeMillis(), list5, list6, values);
            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    // 查询设备访问日志总条数
    public static long countDeviceLogInfo(IotDbConfig iotDbConfig, DeviceLogInfo deviceLogInfo) {
        long num = 0;
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            SessionPool sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();


            StringBuffer sb = new StringBuffer();
            sb.append("select count(userId) from root.myDeviceLogInfo.tableOne");
            if ((null != deviceLogInfo.getEndTime() && 0 != deviceLogInfo.getEndTime())
                    || (null != deviceLogInfo.getBeginTime() && 0 != deviceLogInfo.getBeginTime())
                    || (null != deviceLogInfo.getType() && !"".equals(deviceLogInfo.getType()))) {
                sb.append(" where");
                boolean needAnd = false;
                if (null != deviceLogInfo.getEndTime() && 0 != deviceLogInfo.getEndTime() ) {
                    needAnd = true;
                    sb.append(" accessed <= "+ deviceLogInfo.getEndTime());
                }
                if (null != deviceLogInfo.getBeginTime() && 0 != deviceLogInfo.getBeginTime()) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" accessed >= "+ deviceLogInfo.getBeginTime());

                }
                if (null != deviceLogInfo.getType() && !"".equals(deviceLogInfo.getType())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" type = '" + deviceLogInfo.getType() + "'");
                }
            }
            String sql = sb.toString();
            System.out.println(sql);
            SessionDataSetWrapper sessionDataSetWrapper = sessionPool.executeQueryStatement(sql);
            List<String> columnNames = sessionDataSetWrapper.getColumnNames();
            System.out.println(columnNames);
            while (sessionDataSetWrapper.hasNext()) {
                RowRecord next = sessionDataSetWrapper.next(); // 取出一行数据
                long timestamp = next.getTimestamp(); // 获取这行的时间戳
                List<Field> fields = next.getFields();
                Field field0 = fields.get(0);
                num = field0.getLongV();
            }

            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }

        return num;
    }

    // 查询设备访问日志列表
    public static List<DeviceLogInfo> selectDeviceLogInfo(IotDbConfig iotDbConfig, DeviceLogInfo deviceLogInfo) {
        List<DeviceLogInfo> deviceLogInfoList = new ArrayList<>();
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            SessionPool sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            int offsetNum = (deviceLogInfo.getPageNum() - 1) * deviceLogInfo.getPageSize();
            int limitNum = deviceLogInfo.getPageSize();
            StringBuffer sb = new StringBuffer();
            sb.append("select roleId, roleName, userId, username, deviceId, deviceName, deviceTypeId, deviceTypeName, deviceSn, accessed, type, clientIp, remark from root.myDeviceLogInfo.tableOne");
            if ((null != deviceLogInfo.getEndTime() && 0 != deviceLogInfo.getEndTime())
                    || (null != deviceLogInfo.getBeginTime() && 0 != deviceLogInfo.getBeginTime())
                    || (null != deviceLogInfo.getType() && !"".equals(deviceLogInfo.getType()))) {
                sb.append(" where");
                boolean needAnd = false;
                if (null != deviceLogInfo.getEndTime() && 0 != deviceLogInfo.getEndTime() ) {
                    needAnd = true;
                    sb.append(" accessed <= "+ deviceLogInfo.getEndTime());
                }
                if (null != deviceLogInfo.getBeginTime() && 0 != deviceLogInfo.getBeginTime()) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" accessed >= "+ deviceLogInfo.getBeginTime());

                }
                if (null != deviceLogInfo.getType() && !"".equals(deviceLogInfo.getType())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" type = '" + deviceLogInfo.getType() + "'");
                }
            }
            sb.append(" order by time desc offset " + offsetNum + " limit " + limitNum);
            String sql = sb.toString();
            System.out.println(sql);
            SessionDataSetWrapper sessionDataSetWrapper = sessionPool.executeQueryStatement(sql);
            List<String> columnNames = sessionDataSetWrapper.getColumnNames();
            System.out.println(columnNames);
            while (sessionDataSetWrapper.hasNext()) {
                RowRecord next = sessionDataSetWrapper.next(); // 取出一行数据
                long timestamp = next.getTimestamp(); // 获取这行的时间戳
                List<Field> fields = next.getFields();
                Field field0 = fields.get(0);
                String roleId = field0.getStringValue();
                Field field1 = fields.get(1);
                String roleName = field1.getStringValue();
                Field field2 = fields.get(2);
                String userId = field2.getStringValue();
                Field field3 = fields.get(3);
                String username = field3.getStringValue();
                Field field4 = fields.get(4);
                String deviceId = field4.getStringValue();
                Field field5 = fields.get(5);
                String deviceName = field5.getStringValue();
                Field field6 = fields.get(6);
                String deviceTypeId = field6.getStringValue();
                Field field7 = fields.get(7);
                String deviceTypeName = field7.getStringValue();
                Field field8 = fields.get(8);
                String deviceSn = field8.getStringValue();
                Field field9 = fields.get(9);
                long accessed = field9.getLongV();
                Field field10 = fields.get(10);
                String type = field10.getStringValue();
                Field field11 = fields.get(11);
                String clientIp = field11.getStringValue();
                Field field12 = fields.get(12);
                String remark = field12.getStringValue();

                DeviceLogInfo deviceLogInfo1 = new DeviceLogInfo();
                deviceLogInfo1.setTimesta(timestamp);
                deviceLogInfo1.setTimestaStr(MyDateUtils.longToString(timestamp));
                deviceLogInfo1.setRoleId(roleId);
                deviceLogInfo1.setRoleName(roleName);
                deviceLogInfo1.setUserId(userId);
                deviceLogInfo1.setUsername(username);

                deviceLogInfo1.setDeviceId(deviceId);
                deviceLogInfo1.setDeviceName(deviceName);
                deviceLogInfo1.setDeviceTypeId(deviceTypeId);
                deviceLogInfo1.setDeviceTypeName(deviceTypeName);
                deviceLogInfo1.setDeviceSn(deviceSn);

                deviceLogInfo1.setAccessed(MyDateUtils.longToString(accessed));
                deviceLogInfo1.setType(type);
                deviceLogInfo1.setClientIp(clientIp);
                deviceLogInfo1.setRemark(remark);
                deviceLogInfoList.add(deviceLogInfo1);
            }

            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }
        return deviceLogInfoList;
    }

    // 查询设备非法访问日志总条数
    public static long countDeviceLogInfo_ill(IotDbConfig iotDbConfig, DeviceIllLogInfo deviceIllLogInfo) {
        long num = 0;
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            SessionPool sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();


            StringBuffer sb = new StringBuffer();
            sb.append("select count(userId) from root.myDeviceLogInfo.tableTwo");
            if ((null != deviceIllLogInfo.getEndTime() && 0 != deviceIllLogInfo.getEndTime())
                    || (null != deviceIllLogInfo.getBeginTime() && 0 != deviceIllLogInfo.getBeginTime())
                    || (null != deviceIllLogInfo.getIllType() && !"".equals(deviceIllLogInfo.getIllType()))) {
                sb.append(" where");
                boolean needAnd = false;
                if (null != deviceIllLogInfo.getEndTime() && 0 != deviceIllLogInfo.getEndTime() ) {
                    needAnd = true;
                    sb.append(" accessed <= "+ deviceIllLogInfo.getEndTime());
                }
                if (null != deviceIllLogInfo.getBeginTime() && 0 != deviceIllLogInfo.getBeginTime()) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" accessed >= "+ deviceIllLogInfo.getBeginTime());

                }
                if (null != deviceIllLogInfo.getIllType() && !"".equals(deviceIllLogInfo.getIllType())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" type = '" + deviceIllLogInfo.getIllType() + "'");
                }
            }
            String sql = sb.toString();
            System.out.println(sql);
            SessionDataSetWrapper sessionDataSetWrapper = sessionPool.executeQueryStatement(sql);
            List<String> columnNames = sessionDataSetWrapper.getColumnNames();
            System.out.println(columnNames);
            while (sessionDataSetWrapper.hasNext()) {
                RowRecord next = sessionDataSetWrapper.next(); // 取出一行数据
                long timestamp = next.getTimestamp(); // 获取这行的时间戳
                List<Field> fields = next.getFields();
                Field field0 = fields.get(0);
                num = field0.getLongV();
            }

            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }

        return num;
    }

    // 查询设备访问日志列表
    public static List<DeviceIllLogInfo> selectDeviceLogInfo_ill(IotDbConfig iotDbConfig, DeviceIllLogInfo deviceIllLogInfo) {
        List<DeviceIllLogInfo> deviceIllLogInfoList = new ArrayList<>();
        try {
            List<String> nodeUrls = new ArrayList<>();
            nodeUrls.add(iotDbConfig.getIp() + ":" + iotDbConfig.getPort());
            SessionPool sessionPool =
                    new SessionPool.Builder()
                            .nodeUrls(nodeUrls)
                            .user(iotDbConfig.getUsername())
                            .password(iotDbConfig.getPassword())
                            .maxSize(3)
                            .build();

            int offsetNum = (deviceIllLogInfo.getPageNum() - 1) * deviceIllLogInfo.getPageSize();
            int limitNum = deviceIllLogInfo.getPageSize();
            StringBuffer sb = new StringBuffer();
            sb.append("select roleId, roleName, userId, username, deviceId, deviceName, deviceTypeId, deviceTypeName, deviceSn, accessed, illType, clientIp, remark from root.myDeviceLogInfo.tableTwo");
            if ((null != deviceIllLogInfo.getEndTime() && 0 != deviceIllLogInfo.getEndTime())
                    || (null != deviceIllLogInfo.getBeginTime() && 0 != deviceIllLogInfo.getBeginTime())
                    || (null != deviceIllLogInfo.getIllType() && !"".equals(deviceIllLogInfo.getIllType()))) {
                sb.append(" where");
                boolean needAnd = false;
                if (null != deviceIllLogInfo.getEndTime() && 0 != deviceIllLogInfo.getEndTime() ) {
                    needAnd = true;
                    sb.append(" accessed <= "+ deviceIllLogInfo.getEndTime());
                }
                if (null != deviceIllLogInfo.getBeginTime() && 0 != deviceIllLogInfo.getBeginTime()) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" accessed >= "+ deviceIllLogInfo.getBeginTime());

                }
                if (null != deviceIllLogInfo.getIllType() && !"".equals(deviceIllLogInfo.getIllType())) {
                    if (needAnd) {
                        sb.append(" and");
                    }
                    needAnd = true;
                    sb.append(" type = '" + deviceIllLogInfo.getIllType() + "'");
                }
            }
            sb.append(" order by time desc offset " + offsetNum + " limit " + limitNum);
            String sql = sb.toString();
            System.out.println(sql);
            SessionDataSetWrapper sessionDataSetWrapper = sessionPool.executeQueryStatement(sql);
            List<String> columnNames = sessionDataSetWrapper.getColumnNames();
            System.out.println(columnNames);
            while (sessionDataSetWrapper.hasNext()) {
                RowRecord next = sessionDataSetWrapper.next(); // 取出一行数据
                long timestamp = next.getTimestamp(); // 获取这行的时间戳
                List<Field> fields = next.getFields();
                Field field0 = fields.get(0);
                String roleId = field0.getStringValue();
                Field field1 = fields.get(1);
                String roleName = field1.getStringValue();
                Field field2 = fields.get(2);
                String userId = field2.getStringValue();
                Field field3 = fields.get(3);
                String username = field3.getStringValue();
                Field field4 = fields.get(4);
                String deviceId = field4.getStringValue();
                Field field5 = fields.get(5);
                String deviceName = field5.getStringValue();
                Field field6 = fields.get(6);
                String deviceTypeId = field6.getStringValue();
                Field field7 = fields.get(7);
                String deviceTypeName = field7.getStringValue();
                Field field8 = fields.get(8);
                String deviceSn = field8.getStringValue();
                Field field9 = fields.get(9);
                long accessed = field9.getLongV();
                Field field10 = fields.get(10);
                String illType = field10.getStringValue();
                Field field11 = fields.get(11);
                String clientIp = field11.getStringValue();
                Field field12 = fields.get(12);
                String remark = field12.getStringValue();

                DeviceIllLogInfo deviceIllLogInfo1 = new DeviceIllLogInfo();
                deviceIllLogInfo1.setTimesta(timestamp);
                deviceIllLogInfo1.setTimestaStr(MyDateUtils.longToString(timestamp));
                deviceIllLogInfo1.setRoleId(roleId);
                deviceIllLogInfo1.setRoleName(roleName);
                deviceIllLogInfo1.setUserId(userId);
                deviceIllLogInfo1.setUsername(username);

                deviceIllLogInfo1.setDeviceId(deviceId);
                deviceIllLogInfo1.setDeviceName(deviceName);
                deviceIllLogInfo1.setDeviceTypeId(deviceTypeId);
                deviceIllLogInfo1.setDeviceTypeName(deviceTypeName);
                deviceIllLogInfo1.setDeviceSn(deviceSn);

                deviceIllLogInfo1.setAccessed(MyDateUtils.longToString(accessed));
                deviceIllLogInfo1.setIllType(illType);
                deviceIllLogInfo1.setClientIp(clientIp);
                deviceIllLogInfo1.setRemark(remark);
                deviceIllLogInfoList.add(deviceIllLogInfo1);
            }

            sessionPool.close();
        } catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        } catch (StatementExecutionException e) {
            throw new RuntimeException(e);
        }
        return deviceIllLogInfoList;
    }
}
