package cn.gintone.entity;

import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.yudao.framework.mybatis.core.dataobject.BaseDO;

/**
 * 访问规则配置 DO
 *
 * @author 胡懿
 */
@TableName("t_visit_info")
@KeySequence("t_visit_info_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class VisitInfoDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 规则表外键
     */
    private Long visitId;
    /**
     * 系统简称
     */
    private Long sysAbbre;
    /**
     * 系统名称
     */
    private String sysAbbreName;
    /**
     * 菜单名称
     */
    private String urlName;
    /**
     * 菜单地址
     */
    private String url;
    /**
     * 菜单地址Id
     */
    private Long urlId;
    /**
     * 角色id
     */
    private String roleId;
    /**
     * 角色名称
     */
    private String roleName;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 用户名称
     */
    private String userName;

}