package cn.gintone.dal;


import cn.gintone.controller.vo.UserDesRulePageReqVO;
import cn.gintone.entity.UserDesRuleDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.yudao.framework.mybatis.core.query.LambdaQueryWrapperX;
import org.apache.ibatis.annotations.Mapper;

/**
 * 人员脱敏规则 Mapper
 *
 * @author 胡懿
 */
@Mapper
public interface UserDesRuleMapper extends BaseMapperX<UserDesRuleDO> {

    default PageResult<UserDesRuleDO> selectPage(UserDesRulePageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<UserDesRuleDO>()
                .likeIfPresent(UserDesRuleDO::getName, reqVO.getName())
                .likeIfPresent(UserDesRuleDO::getAttr, reqVO.getAttr())
                .betweenIfPresent(UserDesRuleDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(UserDesRuleDO::getId));
    }

}