package cn.gintone.dal;

import java.util.*;

import cn.gintone.controller.vo.PtDeptInfoPageReqVO;
import cn.gintone.entity.PtDeptInfoDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.yudao.framework.mybatis.core.mapper.BaseMapperX;
import org.apache.ibatis.annotations.Mapper;

/**
 * 平台部门 Mapper
 *
 * @author 安全系统管理
 */
@Mapper
public interface PtDeptInfoMapper extends BaseMapperX<PtDeptInfoDO> {

    default PageResult<PtDeptInfoDO> selectPage(PtDeptInfoPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<PtDeptInfoDO>()
                .eqIfPresent(PtDeptInfoDO::getOrgId, reqVO.getOrgId())
                .eqIfPresent(PtDeptInfoDO::getOrgCode, reqVO.getOrgCode())
                .likeIfPresent(PtDeptInfoDO::getOrgName, reqVO.getOrgName())
                .eqIfPresent(PtDeptInfoDO::getOrgType, reqVO.getOrgType())
                .eqIfPresent(PtDeptInfoDO::getParentOrgId, reqVO.getParentOrgId())
                .likeIfPresent(PtDeptInfoDO::getParentOrgName, reqVO.getParentOrgName())
                .betweenIfPresent(PtDeptInfoDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(PtDeptInfoDO::getId));
    }

}