package cn.gintone.controller;

import cn.gintone.config.IotDbConfig;
import cn.gintone.controller.vo.ImportantFilePageReqVO;
import cn.gintone.controller.vo.ImportantFileRespVO;
import cn.gintone.controller.vo.ImportantFileSaveReqVO;
import cn.gintone.dto.FileDecLogInfo;
import cn.gintone.dto.WebIllLogInfo;
import cn.gintone.dto.WebLogInfoVo;
import cn.gintone.entity.ImportantFileDO;
import cn.gintone.iotdbUtils.FileIotDbUtil;
import cn.gintone.iotdbUtils.MyIotDbUtils;
import cn.gintone.service.ImportantFileService;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Operation;

import javax.validation.*;
import javax.servlet.http.*;
import java.io.IOException;
import java.util.List;

import cn.iocoder.yudao.framework.common.pojo.PageParam;
import cn.iocoder.yudao.framework.common.pojo.CommonResult;
import cn.iocoder.yudao.framework.common.util.object.BeanUtils;
import static cn.iocoder.yudao.framework.common.pojo.CommonResult.success;

import cn.iocoder.yudao.framework.excel.core.util.ExcelUtils;

import cn.iocoder.yudao.framework.apilog.core.annotation.ApiAccessLog;
import static cn.iocoder.yudao.framework.apilog.core.enums.OperateTypeEnum.*;


@Tag(name = "管理后台 - 重要文件")
@RestController
@RequestMapping("/admin-api/sec/important-file")
@Validated
public class ImportantFileController {

    @Resource
    private ImportantFileService importantFileService;
    @Autowired
    private IotDbConfig iotDbConfig;

    @PostMapping("/create")
    @Operation(summary = "创建重要文件")
    @PreAuthorize("@ss.hasPermission('sec:important-file:create')")
    public CommonResult<Long> createImportantFile(@Valid @RequestBody ImportantFileSaveReqVO createReqVO) {
        return success(importantFileService.createImportantFile(createReqVO));
    }

    @PutMapping("/update")
    @Operation(summary = "更新重要文件")
    @PreAuthorize("@ss.hasPermission('sec:important-file:update')")
    public CommonResult<Boolean> updateImportantFile(@Valid @RequestBody ImportantFileSaveReqVO updateReqVO) {
        importantFileService.updateImportantFile(updateReqVO);
        return success(true);
    }

    @DeleteMapping("/delete")
    @Operation(summary = "删除重要文件")
    @Parameter(name = "id", description = "编号", required = true)
    @PreAuthorize("@ss.hasPermission('sec:important-file:delete')")
    public CommonResult<Boolean> deleteImportantFile(@RequestParam("id") Long id) {
        importantFileService.deleteImportantFile(id);
        return success(true);
    }

    @GetMapping("/get")
    @Operation(summary = "获得重要文件")
    @Parameter(name = "id", description = "编号", required = true, example = "1024")
    @PreAuthorize("@ss.hasPermission('sec:important-file:query')")
    public CommonResult<ImportantFileRespVO> getImportantFile(@RequestParam("id") Long id) {
        ImportantFileDO importantFile = importantFileService.getImportantFile(id);
        return success(BeanUtils.toBean(importantFile, ImportantFileRespVO.class));
    }

    @GetMapping("/page")
    @Operation(summary = "获得重要文件分页")
    @PreAuthorize("@ss.hasPermission('sec:important-file:query')")
    public CommonResult<PageResult<ImportantFileRespVO>> getImportantFilePage(@Valid ImportantFilePageReqVO pageReqVO) {
        PageResult<ImportantFileDO> pageResult = importantFileService.getImportantFilePage(pageReqVO);
        return success(BeanUtils.toBean(pageResult, ImportantFileRespVO.class));
    }

    @GetMapping("/export-excel")
    @Operation(summary = "导出重要文件 Excel")
    @PreAuthorize("@ss.hasPermission('sec:important-file:export')")
    @ApiAccessLog(operateType = EXPORT)
    public void exportImportantFileExcel(@Valid ImportantFilePageReqVO pageReqVO,
              HttpServletResponse response) throws IOException {
        pageReqVO.setPageSize(PageParam.PAGE_SIZE_NONE);
        List<ImportantFileDO> list = importantFileService.getImportantFilePage(pageReqVO).getList();
        // 导出 Excel
        ExcelUtils.write(response, "重要文件.xls", "数据", ImportantFileRespVO.class,
                        BeanUtils.toBean(list, ImportantFileRespVO.class));
    }

    @GetMapping("/countDecFileLogInfo")
    @Operation(summary = "统计重要文件申请解密日志条数")
    public CommonResult<Long> countDecFileLogInfo(FileDecLogInfo fileDecLogInfo) {
        long pageCount = FileIotDbUtil.countDecFileInfo(iotDbConfig, fileDecLogInfo);
        return CommonResult.success(pageCount);
    }

    @GetMapping("/decFileLogInfoList")
    @Operation(summary = "重要文件申请日志记录")
    public CommonResult<List<FileDecLogInfo>> webIllLogInfoList(FileDecLogInfo fileDecLogInfo) {
        List<FileDecLogInfo> fileDecLogInfos = FileIotDbUtil.selectDecFileInfo(iotDbConfig, fileDecLogInfo);
        return CommonResult.success(fileDecLogInfos);
    }

}