package cn.gintone.service;

import cn.gintone.ErrorInfo;
import cn.gintone.controller.vo.SysAbbrePageReqVO;
import cn.gintone.controller.vo.SysAbbreSaveReqVO;
import cn.gintone.dal.SysAbbreMapper;
import cn.gintone.entity.SysAbbreDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import cn.iocoder.yudao.framework.common.util.object.BeanUtils;

import static cn.iocoder.yudao.framework.common.exception.util.ServiceExceptionUtil.exception;

/**
 * 系统简称 Service 实现类
 *
 * @author 安全系统管理
 */
@Service
@Validated
public class SysAbbreServiceImpl implements SysAbbreService {

    @Resource
    private SysAbbreMapper sysAbbreMapper;

    @Override
    public Long createSysAbbre(SysAbbreSaveReqVO createReqVO) {
        // 插入
        SysAbbreDO sysAbbre = BeanUtils.toBean(createReqVO, SysAbbreDO.class);
        sysAbbreMapper.insert(sysAbbre);
        // 返回
        return sysAbbre.getId();
    }

    @Override
    public void updateSysAbbre(SysAbbreSaveReqVO updateReqVO) {
        // 校验存在
        validateSysAbbreExists(updateReqVO.getId());
        // 更新
        SysAbbreDO updateObj = BeanUtils.toBean(updateReqVO, SysAbbreDO.class);
        sysAbbreMapper.updateById(updateObj);
    }

    @Override
    public void deleteSysAbbre(Long id) {
        // 校验存在
        validateSysAbbreExists(id);
        // 删除
        sysAbbreMapper.deleteById(id);
    }

    private void validateSysAbbreExists(Long id) {
        if (sysAbbreMapper.selectById(id) == null) {
            throw exception(ErrorInfo.SYS_ABBRE_NOT_EXISTS);
        }
    }

    @Override
    public SysAbbreDO getSysAbbre(Long id) {
        return sysAbbreMapper.selectById(id);
    }

    @Override
    public PageResult<SysAbbreDO> getSysAbbrePage(SysAbbrePageReqVO pageReqVO) {
        return sysAbbreMapper.selectPage(pageReqVO);
    }

}