package cn.gintone.entity;

import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.yudao.framework.mybatis.core.dataobject.BaseDO;

/**
 * 公钥私钥管理 DO
 *
 * @author 胡懿
 */
@TableName("t_key_code")
@KeySequence("t_key_code_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class KeyCodeDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 类型用户编号 1:rsa 2:sm2
     */
    private Integer type;
    /**
     * 公钥用户类型
     */
    private String publicKey;
    /**
     * 私钥
     */
    private String privateKey;

}