package cn.gintone.controller.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import com.alibaba.excel.annotation.*;

@Schema(description = "管理后台 - 物联网设备请求配置 Response VO")
@Data
@ExcelIgnoreUnannotated
public class DeviceReqConfRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "9080")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "设备名称", example = "张三")
    @ExcelProperty("设备名称")
    private String deviceName;

    @Schema(description = "设备id", requiredMode = Schema.RequiredMode.REQUIRED, example = "21048")
    @ExcelProperty("设备id")
    private String deviceId;

    @Schema(description = "设备类型id", example = "24373")
    @ExcelProperty("设备类型id")
    private String deviceTypeId;

    @Schema(description = "父级id", example = "31343")
    @ExcelProperty("父级id")
    private Long parentId;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

    private String snCode; // sn
    private String address; // 地址
    private String deviceEn; // 设备英文
    private String regionName; // 区域名称
    private String deviceTypeName;
}