package cn.gintone.controller.vo;

import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.yudao.framework.common.pojo.PageParam;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.yudao.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 设备规则配置细则分页 Request VO")
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class DeviceConnetRuleInfoPageReqVO extends PageParam {

    @Schema(description = "规则外键", example = "11033")
    private Long deviceRuleId;

    @Schema(description = "设备名称", example = "李四")
    private String deviceName;

    @Schema(description = "设备id", example = "10642")
    private String deviceId;

    @Schema(description = "角色", example = "9412")
    private String roleId;

    @Schema(description = "角色名称", example = "张三")
    private String roleName;

    @Schema(description = "用户id", example = "31481")
    private String userId;

    @Schema(description = "用户名称", example = "芋艿")
    private String userName;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

    private String deviceSn; // 设备sn

}