package cn.gintone.entity;

import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.yudao.framework.mybatis.core.dataobject.BaseDO;

/**
 * 设备规则配置细则 DO
 *
 * @author 胡懿
 */
@TableName("t_device_connet_rule_info")
@KeySequence("t_device_connet_rule_info_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DeviceConnetRuleInfoDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 规则外键
     */
    private Long deviceRuleId;
    /**
     * 设备名称
     */
    private String deviceName;
    /**
     * 设备id
     */
    private String deviceId;
    /**
     * 角色
     */
    private String roleId;
    /**
     * 角色名称
     */
    private String roleName;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 用户名称
     */
    private String userName;

}