package cn.gintone.dal;

import cn.gintone.controller.vo.VisitPageReqVO;
import cn.gintone.entity.VisitDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.yudao.framework.mybatis.core.query.LambdaQueryWrapperX;
import org.apache.ibatis.annotations.Mapper;

/**
 * 接口安全访问策略 Mapper
 *
 * @author 胡懿
 */
@Mapper
public interface VisitMapper extends BaseMapperX<VisitDO> {

    default PageResult<VisitDO> selectPage(VisitPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<VisitDO>()
                .likeIfPresent(VisitDO::getName, reqVO.getName())
                .betweenIfPresent(VisitDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(VisitDO::getId));
    }

}