package cn.gintone.dal;

import cn.gintone.controller.vo.DeviceConnetRulePageReqVO;
import cn.gintone.entity.DeviceConnetRuleDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.yudao.framework.mybatis.core.query.LambdaQueryWrapperX;
import org.apache.ibatis.annotations.Mapper;

/**
 * 设备连接规则 Mapper
 *
 * @author 胡懿
 */
@Mapper
public interface DeviceConnetRuleMapper extends BaseMapperX<DeviceConnetRuleDO> {

    default PageResult<DeviceConnetRuleDO> selectPage(DeviceConnetRulePageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<DeviceConnetRuleDO>()
                .likeIfPresent(DeviceConnetRuleDO::getName, reqVO.getName())
                .betweenIfPresent(DeviceConnetRuleDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(DeviceConnetRuleDO::getId));
    }

}