package cn.gintone.controller.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import com.alibaba.excel.annotation.*;

@Schema(description = "管理后台 - 设备规则配置细则 Response VO")
@Data
@ExcelIgnoreUnannotated
public class DeviceConnetRuleInfoRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "18505")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "规则外键", requiredMode = Schema.RequiredMode.REQUIRED, example = "11033")
    @ExcelProperty("规则外键")
    private Long deviceRuleId;

    @Schema(description = "设备名称", example = "李四")
    @ExcelProperty("设备名称")
    private String deviceName;

    @Schema(description = "设备id", example = "10642")
    @ExcelProperty("设备id")
    private String deviceId;

    @Schema(description = "角色", example = "9412")
    @ExcelProperty("角色")
    private String roleId;

    @Schema(description = "角色名称", example = "张三")
    @ExcelProperty("角色名称")
    private String roleName;

    @Schema(description = "用户id", example = "31481")
    @ExcelProperty("用户id")
    private String userId;

    @Schema(description = "用户名称", example = "芋艿")
    @ExcelProperty("用户名称")
    private String userName;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

}