package cn.gintone.controller;

import cn.gintone.config.IotDbConfig;
import cn.gintone.dto.WebIllLogInfo;
import cn.gintone.dto.WebLogInfo;
import cn.gintone.dto.WebLogInfoVo;
import cn.gintone.iotdbUtils.*;
import cn.iocoder.yudao.framework.common.pojo.CommonResult;
import com.alibaba.fastjson.JSON;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.security.PermitAll;
import java.util.Date;
import java.util.List;

@RestController
@RequestMapping("/admin-api/gintone/webLogInfo")
public class WebLogInfoController {
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Autowired
    private IotDbConfig iotDbConfig;

    @PostMapping("/initIotDBDatabase")
    @Operation(summary = "初始化数据库")
    public CommonResult<String> initIotDBDatabase() {
        MyIotDbUtils.createDatabase(iotDbConfig);
        MyIotDbUtils.createWebLogInfoTimeseries(iotDbConfig);
        MyIotDbUtils.createIllegalLogTimeseries(iotDbConfig);
        FileIotDbUtil.createFileLogInfoTimeseries(iotDbConfig);
        SpecialPeopleIotDbUtils.createSpeLogInfoTimeseries(iotDbConfig);
        JarDecLogIotDbUtil.createJarDecLogInfoTimeseries(iotDbConfig);
        return CommonResult.success("初始化成功");
    }

    @PostMapping("/initIotDBTable")
    @Operation(summary = "初始化时间序列")
    public CommonResult<String> initIotDBTable() {
        MyIotDbUtils.createWebLogInfoTimeseries(iotDbConfig);
        return CommonResult.success("初始化成功");
    }

    @PostMapping("/initIllIotDBTable")
    @Operation(summary = "初始非法访问化时间序列")
    public CommonResult<String> initIllIotDBTable() {
        MyIotDbUtils.createIllegalLogTimeseries(iotDbConfig);
        return CommonResult.success("初始化成功");
    }

    @PostMapping("/initDecFileIotDBTable")
    @Operation(summary = "初始化重要文件时间序列")
    public CommonResult<String> initDecFileIotDBTable() {
        FileIotDbUtil.createFileLogInfoTimeseries(iotDbConfig);
        return CommonResult.success("初始化成功");
    }
    @PostMapping("/initSpeLogIotDBTable")
    @Operation(summary = "初始化重点人群时间序列")
    public CommonResult<String> initSpeLogIotDBTable() {
        SpecialPeopleIotDbUtils.createSpeLogInfoTimeseries(iotDbConfig);
        return CommonResult.success("初始化成功");
    }

    @PostMapping("/initJarDecLogIotDBTable")
    @Operation(summary = "初始化jar加密时间序列")
    public CommonResult<String> initJarDecLogIotDBTable() {
        JarDecLogIotDbUtil.createJarDecLogInfoTimeseries(iotDbConfig);
        return CommonResult.success("初始化成功");
    }

    @PermitAll
    @PostMapping("/saveWebLogInfo")
    @Operation(summary = "外部性请求保存日志")
    public CommonResult<String> saveWebLogInfo(@RequestBody WebLogInfo webLogInfo) {
        if (null == webLogInfo.getAccessed()) {
            webLogInfo.setAccessed(MyDateUtils.longToString(new Date().getTime()));
        }
        String webLogInfoStr = JSON.toJSONString(webLogInfo);
        rabbitTemplate.convertAndSend("my_boot_topic_exchange", "weblog.save", webLogInfoStr);
        return CommonResult.success("保存成功");
    }

    @GetMapping("/countWebLogInfo")
    @Operation(summary = "统计日志条数接口")
    public CommonResult<Long> countWebLogInfo(WebLogInfoVo webLogInfoVo) {
        long pageCount = MyIotDbUtils.countWebInfo(iotDbConfig, webLogInfoVo);
        return CommonResult.success(pageCount);
    }

    @GetMapping("/webLogInfoList")
    @Operation(summary = "查询接口日志接口")
    public CommonResult<List<WebLogInfo>> webLogInfoList(WebLogInfoVo webLogInfoVo) {
        List<WebLogInfo> webLogInfoList = MyIotDbUtils.selectWebInfo(iotDbConfig, webLogInfoVo);
        return CommonResult.success(webLogInfoList);
    }

    @GetMapping("/webLogInfoWarningList")
    @Operation(summary = "查询警告接口日志接口")
    public CommonResult<List<WebLogInfo>> webLogInfoWarningList(WebLogInfoVo webLogInfoVo) {
        webLogInfoVo.setType("warning");
        List<WebLogInfo> webLogInfoList = MyIotDbUtils.selectWebInfo(iotDbConfig, webLogInfoVo);
        return CommonResult.success(webLogInfoList);
    }

    @GetMapping("/webLogInfoErrorList")
    @Operation(summary = "查询警告接口日志接口")
    public CommonResult<List<WebLogInfo>> webLogInfoErrorList(WebLogInfoVo webLogInfoVo) {
        webLogInfoVo.setType("error");
        List<WebLogInfo> webLogInfoList = MyIotDbUtils.selectWebInfo(iotDbConfig, webLogInfoVo);
        return CommonResult.success(webLogInfoList);
    }

    @GetMapping("/countWebIllLogInfo")
    @Operation(summary = "统计非法日志条数接口")
    public CommonResult<Long> countWebIllLogInfo(WebLogInfoVo webLogInfoVo) {
        long pageCount = MyIotDbUtils.countWebIllInfo(iotDbConfig, webLogInfoVo);
        return CommonResult.success(pageCount);
    }

    @GetMapping("/webIllLogInfoList")
    @Operation(summary = "查询非法日志记录")
    public CommonResult<List<WebIllLogInfo>> webIllLogInfoList(WebLogInfoVo webLogInfoVo) {
        List<WebIllLogInfo> webIllLogInfos = MyIotDbUtils.selectWebIllInfo(iotDbConfig, webLogInfoVo);
        return CommonResult.success(webIllLogInfos);
    }
}
