package cn.gintone.controller.vo;

import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.yudao.framework.common.pojo.PageParam;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.yudao.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 访问规则配置分页 Request VO")
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class VisitInfoPageReqVO extends PageParam {

    @Schema(description = "规则表外键", example = "10305")
    private Long visitId;

    @Schema(description = "系统简称")
    private String sysAbbre;

    @Schema(description = "系统名称", example = "王五")
    private String sysAbbreName;

    @Schema(description = "菜单名称", example = "王五")
    private String urlName;

    @Schema(description = "菜单地址", example = "https://www.iocoder.cn")
    private String url;

    @Schema(description = "菜单地址Id", example = "https://www.iocoder.cn")
    private String urlId;

    @Schema(description = "角色id", example = "6818")
    private String roleId;

    @Schema(description = "角色名称", example = "李四")
    private String roleName;

    @Schema(description = "用户id", example = "31619")
    private String userId;

    @Schema(description = "用户名称", example = "王五")
    private String userName;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

}