package cn.gintone.config;

import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 消费者的配置类
 */
@Configuration
public class MyRabbitConfig {
/*
    *//**
     * 不使用topic的模式
     *//*
    private static String EXCHANGE_NAME = "my_boot_fanout_exchange"; // 交换机
    private static String QUEUE_NAME = "my_boot_fanout_queue1"; // 队列名称

    *//**
     * 声明交换机
     *//*
    @Bean
    public FanoutExchange fanoutExchange() {

        return new FanoutExchange(EXCHANGE_NAME, true, false); // 设置交换机，设置是持久化的，设置不自动删除
    }

    *//**
     * 声明队列
     *//*
    @Bean
    public Queue queue() {
        return new Queue(QUEUE_NAME, true,false, false); // 队列名称，是否持久化。是否自动删除
    }

    *//**
     * 创建绑定关系
     *//*
    @Bean
    public Binding binding(FanoutExchange fanoutExchange, Queue queue) {

        return BindingBuilder.bind(queue).to(fanoutExchange); // 把队列绑定到交换机上
    }


*/
    @Autowired
    private IotDbConfig iotDbConfig;

    /**
     * 声明队列、交换机、绑定关系(routing-key)
     */
    private static String QUEUE_NAME = "my_boot_topic_queue";
    private static String EXCHANGE_NAME = "my_boot_topic_exchange";


    /**
     * 申明队列
     * @return
     */
    @Bean
    public Queue queue() {
        return new Queue(QUEUE_NAME, true,false, false); // 队列名称，是否持久化。是否自动删除
    }

    /**
     * 申明交换机
     * @return
     */
    @Bean
    public TopicExchange topicExchange() {
        return new TopicExchange(EXCHANGE_NAME, true, false);
    }

    /**
     * 申明绑定关系
     */
    @Bean
    public Binding queueBinding(Queue queue, TopicExchange topicExchange) {
        return BindingBuilder.bind(queue).to(topicExchange).with("weblog.*");
    }
}
