package cn.gintone.entity;

import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.yudao.framework.mybatis.core.dataobject.BaseDO;

/**
 * 人员脱敏规则 DO
 *
 * @author 胡懿
 */
@TableName("t_user_des_rule")
@KeySequence("t_user_des_rule_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class UserDesRuleDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 属性名称
     */
    private String name;
    /**
     * 属性描述
     */
    private String attr;

    /**
     * 规则
     */
    private Integer rule;
    /**
     * 配置项1
     */
    private String valueOne;
    /**
     * 配置项2
     */
    private String valueTwo;
    /**
     * 配置项3
     */
    private String valueThree;

}