package cn.gintone.controller.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import com.alibaba.excel.annotation.*;

@Schema(description = "管理后台 - 公钥私钥管理 Response VO")
@Data
@ExcelIgnoreUnannotated
public class KeyCodeRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "4344")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "类型用户编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "1")
    @ExcelProperty("类型用户编号")
    private Integer type;

    @Schema(description = "公钥用户类型", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("公钥用户类型")
    private String publicKey;

    @Schema(description = "私钥", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("私钥")
    private String privateKey;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

    @Schema(description = "更新时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("更新时间")
    private LocalDateTime updateTime;

}