package cn.gintone.service;

import java.util.*;
import javax.validation.*;

import cn.gintone.controller.vo.DeviceReqConfListReqVO;
import cn.gintone.controller.vo.DeviceReqConfSaveReqVO;
import cn.gintone.entity.DeviceReqConfDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.common.pojo.PageParam;

/**
 * 物联网设备请求配置 Service 接口
 *
 * @author 安全系统管理
 */
public interface DeviceReqConfService {

    /**
     * 创建物联网设备请求配置
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createDeviceReqConf(@Valid DeviceReqConfSaveReqVO createReqVO);

    /**
     * 更新物联网设备请求配置
     *
     * @param updateReqVO 更新信息
     */
    void updateDeviceReqConf(@Valid DeviceReqConfSaveReqVO updateReqVO);

    /**
     * 删除物联网设备请求配置
     *
     * @param id 编号
     */
    void deleteDeviceReqConf(Long id);

    /**
     * 获得物联网设备请求配置
     *
     * @param id 编号
     * @return 物联网设备请求配置
     */
    DeviceReqConfDO getDeviceReqConf(Long id);

    /**
     * 获得物联网设备请求配置列表
     *
     * @param listReqVO 查询条件
     * @return 物联网设备请求配置列表
     */
    List<DeviceReqConfDO> getDeviceReqConfList(DeviceReqConfListReqVO listReqVO);

//    String syncPtDevice();

    String exportPtDevice();

    String exportPtDeviceType();
}