package cn.gintone.controller.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import com.alibaba.excel.annotation.*;

@Schema(description = "管理后台 - 系统简称 Response VO")
@Data
@ExcelIgnoreUnannotated
public class SysAbbreRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "31439")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "系统简称中文")
    @ExcelProperty("系统简称中文")
    private String abbreCn;

    @Schema(description = "系统简称英文")
    @ExcelProperty("系统简称英文")
    private String abbreEn;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

}