package cn.gintone.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

@Service
public class KafkaProducer {
    private final KafkaTemplate<String, String> kafkaTemplate1;
    private final KafkaTemplate<String, String> kafkaTemplate2;

    private static final String TOPIC_WEBLOG = "weblog.save";
    private static final String TOPIC_DEVICELOG = "devicelog.save";

    @Autowired
    public KafkaProducer(
            @Qualifier("kafkaTemplate1") KafkaTemplate<String, String> kafkaTemplate1,
            @Qualifier("kafkaTemplate2") KafkaTemplate<String, String> kafkaTemplate2) {
        this.kafkaTemplate1 = kafkaTemplate1;
        this.kafkaTemplate2 = kafkaTemplate2;
    }

    // 发送到第一个Kafka集群
    public void sendWebLogMessage(String message) {
        kafkaTemplate1.send(TOPIC_WEBLOG, message);
    }

    public void sendDeviceLogMessage(String message) {
        kafkaTemplate1.send(TOPIC_DEVICELOG, message);
    }

    // 发送到第二个Kafka集群（如果需要）
    public void sendToCluster2(String topic, String message) {
        kafkaTemplate2.send(topic, message);
    }
}